/********** ScienceLMCSignal.C ****************************************************************************************\

 $Header$

 REVISION HISTORY
   05/00   Charles Cavanaugh
   02/02   Debbie Mao

 $Log$

\**********************************************************************************************************************/

#include <math.h>
#include "ScienceLMCSignal.h"

science_lmc_signal :: science_lmc_signal ()
{
  ;
}


science_lmc_signal :: ~science_lmc_signal ()
{
  ;
}


void science_lmc_signal :: ComputeMidpointSignal (double const sectorvalues [LMC_ROTATIONS], double& average) const
{
  // compute the mean
  average = 0.0;
  for (int rotation = 0; rotation < LMC_ROTATIONS; rotation++)
    average += (double) sectorvalues [rotation];
  average /= (double) LMC_ROTATIONS;
}


void science_lmc_signal :: ComputeMidpointSignal (double const sectorvalues [LMC_ROTATIONS], double& average, 
                                                  double& variance) const
{
  // compute the mean
  ComputeMidpointSignal (sectorvalues, average);

  // compute the variance of the mean
  variance = 0.0;
  for (int rotation = 0; rotation < LMC_ROTATIONS; rotation++)
    variance += pow ((average - (double) sectorvalues [rotation]), 2.0);
  variance /= (double) (LMC_ROTATIONS - 1);
}


void science_lmc_signal :: ComputeSignal (double const openmeans [LMC_SECTORS], 
                                          double const openvariances [LMC_SECTORS],
                                          double const closedmeans [LMC_SECTORS],
                                          double const closedvariances [LMC_SECTORS],
                                          double signals [LMC_SIGNAL_TERMS],
					  double secsignals [SECTOR_SIGNAL_TERMS] ) const
{
  secsignals [LMC_SIGNAL_A_SECTOR_MEAN]  = openmeans [LMC_A_SECTOR] - closedmeans [LMC_A_SECTOR];
  secsignals [LMC_SIGNAL_B_SECTOR_MEAN]  = openmeans [LMC_B_SECTOR] - closedmeans [LMC_B_SECTOR];
  secsignals [LMC_SIGNAL_C_SECTOR_MEAN]  = openmeans [LMC_C_SECTOR] - closedmeans [LMC_C_SECTOR];
  secsignals [LMC_SIGNAL_D_SECTOR_MEAN]  = openmeans [LMC_D_SECTOR] - closedmeans [LMC_D_SECTOR];

  secsignals [LMC_SIGNAL_A_SECTOR_VARIANCE]  = openvariances [LMC_A_SECTOR] + closedvariances [LMC_A_SECTOR];
  secsignals [LMC_SIGNAL_B_SECTOR_VARIANCE]  = openvariances [LMC_B_SECTOR] + closedvariances [LMC_B_SECTOR];
  secsignals [LMC_SIGNAL_C_SECTOR_VARIANCE]  = openvariances [LMC_C_SECTOR] + closedvariances [LMC_C_SECTOR];
  secsignals [LMC_SIGNAL_D_SECTOR_VARIANCE]  = openvariances [LMC_D_SECTOR] + closedvariances [LMC_D_SECTOR];

  double longsignal  = ((openmeans   [LMC_A_SECTOR] + openmeans   [LMC_C_SECTOR]) - 
                        (closedmeans [LMC_A_SECTOR] + closedmeans [LMC_C_SECTOR])) / 2.0;
  double shortsignal = ((openmeans   [LMC_B_SECTOR] + openmeans   [LMC_D_SECTOR]) - 
                        (closedmeans [LMC_B_SECTOR] + closedmeans [LMC_D_SECTOR])) / 2.0;
  double longsignalvariance  = (openvariances   [LMC_A_SECTOR] + openvariances   [LMC_C_SECTOR] + 
                                closedvariances [LMC_A_SECTOR] + closedvariances [LMC_C_SECTOR]) / 4.0;
  double shortsignalvariance = (openvariances   [LMC_B_SECTOR] + openvariances   [LMC_D_SECTOR] + 
                                closedvariances [LMC_B_SECTOR] + closedvariances [LMC_D_SECTOR]) / 4.0;

  signals [LMC_SIGNAL_AVERAGE_MEAN]     = (longsignal + shortsignal) / 2.0;
  signals [LMC_SIGNAL_DIFFERENCE_MEAN]  = shortsignal - longsignal;
  signals [LMC_SIGNAL_AVERAGE_VARIANCE]    = (longsignalvariance + shortsignalvariance) / 4.0;
  signals [LMC_SIGNAL_DIFFERENCE_VARIANCE] = longsignalvariance + shortsignalvariance;
}
