/********** ScienceLMCChannel.h ***************************************************************************************\

 $Header$

 REVISION HISTORY
   02/99   Charles Cavanaugh
   05/00   Charles Cavanaugh
   09/01   Debbie Mao
   10/01   Debbie Mao
   02/02   Debbie Mao
   08/02   Debbie Mao

 $Log$

\**********************************************************************************************************************/

#if !defined _MOPITT_L1_SCIENCE_LMC_CHANNEL_

  #define _MOPITT_L1_SCIENCE_LMC_CHANNEL_

  #include "ProcessorParameters.h"
  #include "ScienceChannel.h"
  #include "ScienceLMCSignal.h"
  #include "MOPITTTime.h"

  int const LMC_CHANNEL_SIZE = 198;

  class science_lmc_channel : public science_channel, public science_lmc_signal {
    private :
      static int const LMC_SECTOR_SIZE;
      static int const MAX_DELTA_COUNTS;

      double opencounts   [SCIENCE_PIXELS] [LMC_SECTORS] [LMC_ROTATIONS];
      double closedcounts [SCIENCE_PIXELS] [LMC_SECTORS];

      virtual int ConvertOpenCount      (int) {return 0;}
      bool        IsSolarChannel        () const { return ((channel % 2) == 0 ? true : false);}

    protected :

    public :
      science_lmc_channel ();
      science_lmc_channel (int);
      science_lmc_channel (int, int, int);
      virtual ~science_lmc_channel () = 0;

      double GetClosedCount (int pixelindex, int sectorindex) const {return closedcounts [pixelindex] [sectorindex];}
      double GetOpenCount   (int pixelindex, int sectorindex, int rotationindex) const
                             {return opencounts [pixelindex] [sectorindex] [rotationindex];}
      void   GetSignal      (double [SCIENCE_PIXELS] [LMC_SAWTOOTH_SET], bool [SCIENCE_PIXELS]) const;
      void   GetMeans       (double [SCIENCE_PIXELS] [LMC_SECTORS], double [SCIENCE_PIXELS] [LMC_SECTORS],
                             bool [SCIENCE_PIXELS]) const;
      void   Read           (bool, int const [SCIENCE_PIXELS], unsigned char*, short, short, short, short, 
                             processor_parameters const&);
      void   GetOffset      ( int, int, int [13], int [13] );
  };

#endif
