/********** ScienceGlobalSectorMeans.C ********************************************************************************\

 $Header$

 REVISION HISTORY
   12/00   Charles Cavanaugh

 $Log$

\**********************************************************************************************************************/

#include "ScienceGlobalSectorMeans.h"

science_global_sector_means :: science_global_sector_means ()
{
  ;
}


science_global_sector_means :: ~science_global_sector_means ()
{
  ;
}


bool science_global_sector_means :: Get (int channel, double newmeans [SCIENCE_PIXELS] [LMC_SECTORS], 
                                         double newnoise [SCIENCE_PIXELS] [LMC_SECTORS]) const
{
  bool isretrieved = false;

  int index = GetChannelIndex (channel);
  if (index >= 0)
    isretrieved = channels [index]. Get (newmeans, newnoise);
 
  return isretrieved;
}


bool science_global_sector_means :: Get (int channel, int pixel, double newmeans [LMC_SECTORS], 
                                         double newnoise [LMC_SECTORS]) const
{
  bool isretrieved = false;

  int index = GetChannelIndex (channel);
  if (index >= 0)
    isretrieved = channels [index]. Get (pixel, newmeans, newnoise);

  return isretrieved;
}

 
void science_global_sector_means :: Set (int channel, double const newmeans [SCIENCE_PIXELS] [LMC_SECTORS],
                                         double const newnoise [SCIENCE_PIXELS] [LMC_SECTORS])
{
  int index = GetChannelIndex (channel);
  if (index >= 0)
    channels [index]. Set (newmeans, newnoise);
}
