/********** ScienceConstants.h ****************************************************************************************\

 $Header$

 REVISION HISTORY
   03/99   Charles Cavanaugh
   10/01   Debbie Mao
   02/02   Debbie Mao
   04/02   Debbie Mao
   05/02   Debbie Mao
   08/02   Debbie Mao

 $Log$

\**********************************************************************************************************************/

#if !defined _MOPITT_L1_SCIENCE_CONSTANTS_

  #define _MOPITT_L1_SCIENCE_CONSTANTS_

  int   const   LMC_ROTATIONS          = 4;
  int   const   LMC_SECTORS            = 4;
  int   const   LMC_SIGNAL_TERMS       = 4;
  int   const   SECTOR_SIGNAL_TERMS    = 8;
  int   const   PMC_SIGNAL_TERMS       = 4;
  int   const   LMC_SAWTOOTH_SET       = 16;
  int   const   PMC_STROKES            = 2;
  int   const   SCIENCE_CHANNELS       = 8;
  float const   SCIENCE_MISSING_VALUE  = -9999.0;
  int   const   SCIENCE_PIXELS         = 4;
  int   const   SCIENCE_STARES         = 29;
  int   const   SCIENCE_TRAINS         = 4;
  int   const   STARE_MSECS_GAP        = 450;
  int   const   PMC_SIGNAL_STATES      = 2;
  int   const   SCIENCE_PACKETPOSITION = 5;
  int   const   WARMCAL_STDDEV_TERMS   = 2;
  int   const   SCIENCE_MISSING_INT    = (int) (SCIENCE_MISSING_VALUE + 0.5);
  int   const   MAX_SCIENCE_GRANULE    = 12;

  enum lmc_signal_term_offset     { LMC_SIGNAL_AVERAGE_MEAN,        LMC_SIGNAL_DIFFERENCE_MEAN,
                                    LMC_SIGNAL_AVERAGE_VARIANCE,    LMC_SIGNAL_DIFFERENCE_VARIANCE };

  enum sector_signal_term_offset  { LMC_SIGNAL_A_SECTOR_MEAN,       LMC_SIGNAL_B_SECTOR_MEAN,
				    LMC_SIGNAL_C_SECTOR_MEAN,       LMC_SIGNAL_D_SECTOR_MEAN,
				    LMC_SIGNAL_A_SECTOR_VARIANCE,   LMC_SIGNAL_B_SECTOR_VARIANCE,
				    LMC_SIGNAL_C_SECTOR_VARIANCE,   LMC_SIGNAL_D_SECTOR_VARIANCE };

  enum pmc_signal_term_offset     { PMC_SIGNAL_AVERAGE_AVERAGE,  PMC_SIGNAL_DIFFERENCE_AVERAGE,
                                    PMC_SIGNAL_AVERAGE_VARIANCE, PMC_SIGNAL_DIFFERENCE_VARIANCE };

  enum lmc_sector_offsets         { LMC_A_SECTOR, LMC_B_SECTOR, LMC_C_SECTOR, LMC_D_SECTOR };
  enum pmc_stroke_offsets         { PMC_HIGH_STROKE, PMC_LOW_STROKE };
  enum science_channel_number     { CHANNEL_I, CHANNEL_II };
  enum science_train_data_type    { COLD_DATA_TYPE, WARM_DATA_TYPE, HOT_DATA_TYPE, TEPID_DATA_TYPE };
  enum science_train_type         { CALIBRATION_TRAIN, EARTHVIEW_TRAIN, ERRONEOUS_TRAIN };

  enum pmc_signal_state_offset    { PMC_SIGNAL_AVERAGE, PMC_SIGNAL_DIFFERENCE };
  enum warmcal_stddev_term_offset { WARMCAL_AVERAGE_STDDEV, WARMCAL_DIFFERENCE_STDDEV };

#endif
