/********** ScienceCollection.h ***************************************************************************************\

 $Header$

 REVISION HISTORY
   12/98   Charles Cavanaugh

 $Log$

\**********************************************************************************************************************/

#if !defined _MOPITT_L1_SCIENCE_COLLECTION_

  #define _MOPITT_L1_SCIENCE_COLLECTION_

  #include "L0Collection.h"
  #include "TableCollection.h"
  #include "SciencePacket.h"
  #include "ScienceStare.h"
  #include "ScienceTrain.h"

  PGSt_PC_Logical const SCIENCE_COLLECTION_01_LOGICAL = 41000;
  PGSt_PC_Logical const SCIENCE_COLLECTION_02_LOGICAL = (SCIENCE_COLLECTION_01_LOGICAL + 1);
  PGSt_PC_Logical const SCIENCE_COLLECTION_03_LOGICAL = (SCIENCE_COLLECTION_02_LOGICAL + 1);
  PGSt_PC_Logical const SCIENCE_COLLECTION_04_LOGICAL = (SCIENCE_COLLECTION_03_LOGICAL + 1);
  PGSt_PC_Logical const SCIENCE_COLLECTION_05_LOGICAL = (SCIENCE_COLLECTION_04_LOGICAL + 1);
  PGSt_PC_Logical const SCIENCE_COLLECTION_06_LOGICAL = (SCIENCE_COLLECTION_05_LOGICAL + 1);
  PGSt_PC_Logical const SCIENCE_COLLECTION_07_LOGICAL = (SCIENCE_COLLECTION_06_LOGICAL + 1);
  PGSt_PC_Logical const SCIENCE_COLLECTION_08_LOGICAL = (SCIENCE_COLLECTION_07_LOGICAL + 1);
  PGSt_PC_Logical const SCIENCE_COLLECTION_09_LOGICAL = (SCIENCE_COLLECTION_08_LOGICAL + 1);
  PGSt_PC_Logical const SCIENCE_COLLECTION_10_LOGICAL = (SCIENCE_COLLECTION_09_LOGICAL + 1);
  PGSt_PC_Logical const SCIENCE_COLLECTION_11_LOGICAL = (SCIENCE_COLLECTION_10_LOGICAL + 1);
  PGSt_PC_Logical const SCIENCE_COLLECTION_12_LOGICAL = (SCIENCE_COLLECTION_11_LOGICAL + 1);

  class science_collection : public l0_collection {
    private :
      static int const APID;
      static int const PACKETSIZE;
      static int const PACKETLENGTH;
      static int const APID_ERROR;
      static int const LENGTH_ERROR;
      static int const MONOTONICITY_WARNING;
      static int const ID_WARNING;

      table_collection& tablecollection;
      processor_parameters const& processorparameters;
      mopitt_time       maxstaretime;

      void            CheckMonotonicity (mopitt_time const&, int, int);
      science_packet* NextSciencePacket ();
      science_stare*  NextScienceStare  ();

    protected :

    public :
      science_collection (table_collection&, processor_parameters const&);
      ~science_collection ();

      science_train* GetTrain ();
  };

#endif
