/********** ScienceChannel.h ******************************************************************************************\

 $Header$

 REVISION HISTORY
   02/99   Charles Cavanaugh 
   05/00   Charles Cavanaugh 
   06/00   Charles Cavanaugh 
   09/01   Debbie Mao
   05/02   Debbie Mao
   08/02   Debbie Mao

 $Log$

\**********************************************************************************************************************/

#if !defined _MOPITT_L1_SCIENCE_CHANNEL_

  #define _MOPITT_L1_SCIENCE_CHANNEL_

  #include <math.h>
  #include "ScienceConstants.h"

  class science_channel {
    private :
      static int const TOTAL_CELL_STATES_START;
      static int const LAST_CELL_STATE_START;

      int  minimumvalidcount;
      int  maximumvalidcount;
      bool inrange [SCIENCE_PIXELS];

      void SetRange (bool);

    protected :
      static int const CHANNEL_HEADER_SIZE;
      static int const OUTOFRANGE_WARNING;
      static int const ACTIVE_STATIC;

      bool active;
      int  channel;
      int  totalcellstates;
      int  lastcellstate;

      double Normalize (short choppersamples, short scalefactor, short choppercycles, int counts)
         {return ((counts * pow (2.0, scalefactor)) / (double) (((choppersamples * 4) + 2) * choppercycles));}

      double CheckAndNormalize (int, short, short, short, int);
      void   InvalidateRange   ();
      int    GetL1Pixel        (int, int const [SCIENCE_PIXELS]) const;
      bool   PixelWithinRange  (int pixel) const {return inrange [pixel];}
      void   ReadHeader        (bool, unsigned char*);
      bool   CountWithinRange  (int) const;
      void   SetInRange (bool setting, int pixel) { inrange [pixel] = setting; };

    public :
      science_channel ();
      science_channel (int);
      science_channel (int, int, int);
      virtual ~science_channel () = 0;
      void  GetLastcellState  (int &n) { n= lastcellstate; }
  };

#endif
