/********** ScienceChannel.C ******************************************************************************************\

 $Header$

 REVISION HISTORY
   02/99   Charles Cavanaugh
   05/00   Charles Cavanaugh
   06/00   Charles Cavanaugh
   05/02   Debbie Mao

 $Log$

\**********************************************************************************************************************/

#include "ScienceChannel.h"
#include "DiagnosticReporter.h"

extern diagnostic_reporter diagnosticreporter;

int const science_channel::TOTAL_CELL_STATES_START = 4;
int const science_channel::LAST_CELL_STATE_START   = 5;
int const science_channel::CHANNEL_HEADER_SIZE     = 6;
int const science_channel::OUTOFRANGE_WARNING      = 800;
int const science_channel::ACTIVE_STATIC           = 101;

science_channel :: science_channel ()
{
  minimumvalidcount = 0;
  maximumvalidcount = 0;
  active = false;
  channel = 0;
  totalcellstates = 0;
  lastcellstate = 0;
  SetRange (true);
}


science_channel :: science_channel (int channelnumber)
{
  minimumvalidcount = 0;
  maximumvalidcount = 0;
  active = false;
  channel = channelnumber;
  totalcellstates = 0;
  lastcellstate = 0;
  SetRange (true);
}


science_channel :: science_channel (int channelnumber, int mincount, int maxcount)
{
  minimumvalidcount = mincount;
  maximumvalidcount = maxcount;
  active = false;
  channel = channelnumber;
  totalcellstates = 0;
  lastcellstate = 0;
  SetRange (true);
}


science_channel :: ~science_channel ()
{
  ;
}


void science_channel :: SetRange (bool setting)
{
  for (int pixel = 0; pixel < SCIENCE_PIXELS; pixel++)
    inrange [pixel] = setting;
}


bool science_channel :: CountWithinRange ( int count ) const
{
  bool isinrange = false;
  if ( count >= minimumvalidcount && count <= maximumvalidcount )
    isinrange = true;
  else if ( count == 0 )
    isinrange = true;
  return isinrange;
}


double science_channel :: CheckAndNormalize (int pixel, short choppersamples, short scalefactor, short choppercycles, 
                                             int count)
{
  // if the count is not within the approved range, set pixel range to out-of-range and output message
  if (! CountWithinRange (count)) {
    inrange [pixel] = false;
    char countvalue [15];
    (void) sprintf (countvalue, "%d", count);
    string message = "Detector value out of range: ";
    message += countvalue;
    diagnosticreporter.AddEntry (DIAGNOSTICS_TERSE, DIAGNOSTICS_SCIENCE_MODULE, OUTOFRANGE_WARNING, 0, 0, 0, 0, 0,
                                 channel, (pixel + 1), 0, message);
  }

  // return the normalized count (even if it's messed up, the inrange flag will be used to determine rangeness)
  return (Normalize (choppersamples, scalefactor, choppercycles, count));
}


int science_channel :: GetL1Pixel (int pixel, int const pixelmap [SCIENCE_PIXELS]) const
{
  int l1pixel = 0;

  for (int i = 0; i < SCIENCE_PIXELS; i++)
    if (pixel == pixelmap [i])
      l1pixel = i;

  return l1pixel;
}


void science_channel :: InvalidateRange ()
{
  SetRange (false);
}


void science_channel :: ReadHeader (bool activity, unsigned char* channelheader)
{
  active = activity;
  totalcellstates = (int) channelheader[TOTAL_CELL_STATES_START];
  lastcellstate = (int) ((channelheader[LAST_CELL_STATE_START] & 0x06) >> 1);
}
