/********** ScienceCalibrationRecord.h ********************************************************************************\

 $Header$

 REVISION HISTORY
   11/99   Charles Cavanaugh
   11/00   Charles Cavanaugh
   10/01   Debbie Mao
   02/02   Debbie Mao
   04/02   Debbie Mao
   05/02   Debbie Mao

 $Log$

\**********************************************************************************************************************/

#if !defined _MOPITT_L1_SCIENCE_CALIBRATION_RECORD_

  #define _MOPITT_L1_SCIENCE_CALIBRATION_RECORD_

  #include "MOPITTTime.h"
  #include "ScienceConstants.h"

  class science_calibration_record {
    private :

    protected :
      unsigned short starecount;
      float          temperature;
      int            day;
      int            startmsecs;
      int            stopmsecs;
      unsigned short shadowflag;

    public :
      science_calibration_record ();
      virtual ~science_calibration_record () = 0;

      void           GetHeaderInfo  (unsigned short&, float&, int&, int&, int&, unsigned short&) const;
      virtual double GetLMCSignal   (enum science_train_data_type, int, enum lmc_signal_term_offset) const {return 0.0;}
      virtual double GetLMCSignal   (enum science_channel_number, int, enum lmc_signal_term_offset) const {return 0.0;}
      virtual double GetLMCSignal   (int, enum lmc_signal_term_offset) const {return 0.0;}

      virtual double GetLMCSectorSignal (enum science_train_data_type, int, enum sector_signal_term_offset) const {return 0.0;}
      virtual double GetLMCSectorSignal (enum science_channel_number, int, enum sector_signal_term_offset) const {return 0.0;}
      virtual double GetLMCSectorSignal (int, enum sector_signal_term_offset) const {return 0.0;}
      virtual double GetWarmStddev      ( int, int, enum warmcal_stddev_term_offset ) 
	                                 const {return 0.0;}

      virtual double GetPMCSignal   (int, enum pmc_signal_term_offset ) const {return 0.0;}
      virtual void   GetRecordData  (unsigned short&, float&, int&, int&, int&, unsigned short&,
                                     double [SCIENCE_PIXELS] [LMC_SIGNAL_TERMS],
                                     double [SCIENCE_PIXELS] [LMC_SIGNAL_TERMS],
                                     double [SCIENCE_PIXELS] [SECTOR_SIGNAL_TERMS],
                                     double [SCIENCE_PIXELS] [SECTOR_SIGNAL_TERMS],
				     double [SCIENCE_PACKETPOSITION] [SCIENCE_PIXELS] [PMC_SIGNAL_STATES],
				     double [SCIENCE_PIXELS] [WARMCAL_STDDEV_TERMS] [SCIENCE_PACKETPOSITION]) const {;}
      virtual void   GetRecordData  (unsigned short&, float&, int&, int&, int&, unsigned short&,
                                     double [SCIENCE_PIXELS] [PMC_SIGNAL_TERMS],
                                     double [SCIENCE_PIXELS] [LMC_SIGNAL_TERMS],
                                     double [SCIENCE_PIXELS] [SECTOR_SIGNAL_TERMS], 
                                     double [SCIENCE_PACKETPOSITION] [SCIENCE_PIXELS] [PMC_SIGNAL_STATES],
				     double [SCIENCE_PIXELS] [WARMCAL_STDDEV_TERMS] [SCIENCE_PACKETPOSITION]) const {;}

      mopitt_time    GetStartTime   () const {return mopitt_time (day, startmsecs);}
      float          GetTemperature () const {return temperature;}
      bool           IsInShadow     () const {return (shadowflag ? true : false);}
      void           SetHeaderInfo  (unsigned short, float, int, int, int, unsigned short);
      void           SetHeaderInfo  (float, int, bool, mopitt_time const&, mopitt_time const&);

      virtual void   SetLMCSignals  (enum science_channel_number, double [SCIENCE_PIXELS] [LMC_SIGNAL_TERMS],
				     double [SCIENCE_PIXELS] [SECTOR_SIGNAL_TERMS]) {;}
      virtual void   SetLMCSignals  (enum science_train_data_type, double [SCIENCE_PIXELS] [LMC_SIGNAL_TERMS],
				     double [SCIENCE_PIXELS] [SECTOR_SIGNAL_TERMS]) {;}
      virtual void   SetLMCSignals  (double [SCIENCE_PIXELS] [LMC_SIGNAL_TERMS],
				     double [SCIENCE_PIXELS] [SECTOR_SIGNAL_TERMS]) {;}
      virtual void   SetPMCSignals  (double [SCIENCE_PIXELS] [PMC_SIGNAL_TERMS] ) {;}
      virtual void   SetRecordData  (unsigned short, float, int, int, int, unsigned short, 
                                     double [SCIENCE_PIXELS] [LMC_SIGNAL_TERMS],
                                     double [SCIENCE_PIXELS] [LMC_SIGNAL_TERMS],
                                     double [SCIENCE_PIXELS] [SECTOR_SIGNAL_TERMS],
                                     double [SCIENCE_PIXELS] [SECTOR_SIGNAL_TERMS] ) {;}
      virtual void   SetRecordData  (unsigned short, float, int, int, int, unsigned short,
                                     double [SCIENCE_PIXELS] [PMC_SIGNAL_TERMS],
                                     double [SCIENCE_PIXELS] [LMC_SIGNAL_TERMS],
                                     double [SCIENCE_PIXELS] [SECTOR_SIGNAL_TERMS],
                                     double [SCIENCE_PACKETPOSITION] [SCIENCE_PIXELS] [PMC_SIGNAL_STATES],
				     double [SCIENCE_PIXELS] [WARMCAL_STDDEV_TERMS] [SCIENCE_PACKETPOSITION]) {;}

      virtual void   GetPMCColdSignals (double [SCIENCE_PACKETPOSITION] [SCIENCE_PIXELS] [PMC_SIGNAL_STATES]) const {;}
      virtual void   SetPMCColdSignals (double [SCIENCE_PACKETPOSITION] [SCIENCE_PIXELS] [PMC_SIGNAL_STATES]) {;}


  };

#endif

