/********** ScienceCalibrationRecord.C ********************************************************************************\

 $Header$

 REVISION HISTORY
   03/99   Charles Cavanaugh
   06/99   Tom Lauren
   10/99   Charles Cavanaugh
   11/00   Charles Cavanaugh

 $Log$

\**********************************************************************************************************************/

#include "ScienceCalibrationRecord.h"

science_calibration_record :: science_calibration_record ()
{
  starecount = 0;
  temperature = 0.0;
  day = 0;
  startmsecs = 0;
  stopmsecs = 0;
}


science_calibration_record :: ~science_calibration_record ()
{
  ;
}


void science_calibration_record :: GetHeaderInfo (unsigned short& recordcount, float& recordtemp, int& recordday, 
                                                  int& recordstartmsecs, int& recordstopmsecs, 
                                                  unsigned short& recordshadowflag) const
{
  recordcount      = starecount;
  recordtemp       = temperature;
  recordday        = day;
  recordstartmsecs = startmsecs;
  recordstopmsecs  = stopmsecs;
  recordshadowflag = shadowflag;
}


void science_calibration_record :: SetHeaderInfo (unsigned short recordcount, float recordtemp, int recordday, 
                                                  int recordstartmsecs, int recordstopmsecs,
                                                  unsigned short recordshadowflag)
{
  starecount  = recordcount;
  temperature = recordtemp;
  day         = recordday;
  startmsecs  = recordstartmsecs;
  stopmsecs   = recordstopmsecs;
  shadowflag  = recordshadowflag;
}


void science_calibration_record :: SetHeaderInfo (float newtemperature, int newstarecount, bool newshadowflag, 
                                                  mopitt_time const& starttime, mopitt_time const& stoptime)
{
  temperature = newtemperature;
  starecount  = newstarecount;
  day         = starttime.GetDay ();
  startmsecs  = starttime.GetMsecs ();
  stopmsecs   = stoptime.GetMsecs ();
  shadowflag  = (int) newshadowflag;
}
