/********** ScienceCalibrationLMCRecord.h *****************************************************************************\

 $Header$

 REVISION HISTORY
   11/99   Charles Cavanaugh
   11/00   Charles Cavanaugh
   10/01   Debbie Mao
   02/02   Debbie Mao
   04/02   Debbie Mao
   05/02   Debbie Mao

 $Log$

\**********************************************************************************************************************/

#if !defined _MOPITT_L1_SCIENCE_CALIBRATION_LMC_RECORD_

  #define _MOPITT_L1_SCIENCE_CALIBRATION_LMC_RECORD_

  #include "ScienceCalibrationRecord.h"

  class science_calibration_lmc_record : public science_calibration_record {
    private :
      double signalsI  [SCIENCE_PIXELS] [LMC_SIGNAL_TERMS];
      double signalsII [SCIENCE_PIXELS] [LMC_SIGNAL_TERMS];
      double sectorsignalsI  [SCIENCE_PIXELS] [SECTOR_SIGNAL_TERMS];
      double sectorsignalsII [SCIENCE_PIXELS] [SECTOR_SIGNAL_TERMS];
      double coldcalsignals  [SCIENCE_PACKETPOSITION] [SCIENCE_PIXELS] [PMC_SIGNAL_STATES];
      double warmcalstddev   [SCIENCE_PIXELS] [WARMCAL_STDDEV_TERMS] [SCIENCE_PACKETPOSITION];

    protected :

    public :
      science_calibration_lmc_record ();
      ~science_calibration_lmc_record ();

      void   GetRecordData (unsigned short&, float&, int&, int&, int&, unsigned short&,
                            double [SCIENCE_PIXELS] [LMC_SIGNAL_TERMS], double [SCIENCE_PIXELS] [LMC_SIGNAL_TERMS], 
                            double [SCIENCE_PIXELS] [SECTOR_SIGNAL_TERMS], double [SCIENCE_PIXELS] [SECTOR_SIGNAL_TERMS],
			    double [SCIENCE_PACKETPOSITION] [SCIENCE_PIXELS] [PMC_SIGNAL_STATES],
			    double [SCIENCE_PIXELS] [WARMCAL_STDDEV_TERMS] [SCIENCE_PACKETPOSITION])  const;
      double GetLMCSignal  (enum science_train_data_type, int, enum lmc_signal_term_offset) const;
      double GetLMCSignal  (enum science_channel_number, int, enum lmc_signal_term_offset) const;

      double GetLMCSectorSignal  (enum science_train_data_type, int, enum sector_signal_term_offset) const;
      double GetLMCSectorSignal  (enum science_channel_number, int, enum sector_signal_term_offset) const;

      void   SetLMCSignals (enum science_channel_number, double [SCIENCE_PIXELS] [LMC_SIGNAL_TERMS],
			    double [SCIENCE_PIXELS] [SECTOR_SIGNAL_TERMS] );
      void   SetLMCSignals (enum science_train_data_type, double [SCIENCE_PIXELS] [LMC_SIGNAL_TERMS],
			    double [SCIENCE_PIXELS] [SECTOR_SIGNAL_TERMS] );
      void   SetRecordData (unsigned short, float, int, int, int, unsigned short, 
                            double [SCIENCE_PIXELS] [LMC_SIGNAL_TERMS], double [SCIENCE_PIXELS] [LMC_SIGNAL_TERMS], 
                            double [SCIENCE_PIXELS] [SECTOR_SIGNAL_TERMS], double [SCIENCE_PIXELS] [SECTOR_SIGNAL_TERMS]);
  };

#endif
