/********** ScienceCalibrationLMCRecord.C *****************************************************************************\

 $Header$

 REVISION HISTORY
   11/99   Charles Cavanaugh
   11/00   Charles Cavanaugh
   10/01   Debbie Mao
   02/02   Debbie Mao
   04/02   Debbie Mao
   05/02   Debbie Mao 

 $Log$

\**********************************************************************************************************************/

#include <memory.h>
#include "ScienceCalibrationLMCRecord.h"

science_calibration_lmc_record :: science_calibration_lmc_record ()
                                : science_calibration_record ()
{
  for ( int position = 0; position < SCIENCE_PACKETPOSITION; position++ )
    for ( int pixel = 0; pixel < SCIENCE_PIXELS; pixel++ ) {
      for ( int state = 0; state < PMC_SIGNAL_STATES; state++ )
	coldcalsignals [position][pixel][state] = SCIENCE_MISSING_VALUE;
      for ( int posterm = 0; posterm < WARMCAL_STDDEV_TERMS; posterm++ ) 
	warmcalstddev [pixel][posterm][position] = SCIENCE_MISSING_VALUE;
    }
}


science_calibration_lmc_record :: ~science_calibration_lmc_record ()
{
  ;
}


void science_calibration_lmc_record :: GetRecordData (unsigned short& recordcount, float& recordtemp, int& recordday, 
          int& recordstartmsecs, int& recordstopmsecs, unsigned short& recordshadowflag,
          double recordsignalsI [SCIENCE_PIXELS] [LMC_SIGNAL_TERMS],
          double recordsignalsII [SCIENCE_PIXELS] [LMC_SIGNAL_TERMS], 
          double recordsecsignalsI [SCIENCE_PIXELS] [SECTOR_SIGNAL_TERMS],
          double recordsecsignalsII [SCIENCE_PIXELS] [SECTOR_SIGNAL_TERMS],
          double recordcoldsignals [SCIENCE_PACKETPOSITION] [SCIENCE_PIXELS] [PMC_SIGNAL_STATES],
          double recordwarmsignals [SCIENCE_PIXELS] [WARMCAL_STDDEV_TERMS] [SCIENCE_PACKETPOSITION])  const
{
  GetHeaderInfo (recordcount, recordtemp, recordday, recordstartmsecs, recordstopmsecs, recordshadowflag);
  (void) memcpy ((void*) recordsignalsI,  (const void*) signalsI,  sizeof (double [SCIENCE_PIXELS] [LMC_SIGNAL_TERMS]));
  (void) memcpy ((void*) recordsignalsII, (const void*) signalsII, sizeof (double [SCIENCE_PIXELS] [LMC_SIGNAL_TERMS]));
  (void) memcpy ((void*) recordsecsignalsI,  (const void*) sectorsignalsI,  
                                             sizeof (double [SCIENCE_PIXELS] [SECTOR_SIGNAL_TERMS]));
  (void) memcpy ((void*) recordsecsignalsII, (const void*) sectorsignalsII,
                                             sizeof (double [SCIENCE_PIXELS] [SECTOR_SIGNAL_TERMS]));
  (void) memcpy ((void*) recordcoldsignals , (const void*) coldcalsignals, 
                         sizeof (double [SCIENCE_PACKETPOSITION] [SCIENCE_PIXELS] [PMC_SIGNAL_STATES]));
  (void) memcpy ((void*) recordwarmsignals, (const void*) warmcalstddev, 
                         sizeof (double [SCIENCE_PIXELS] [WARMCAL_STDDEV_TERMS] [SCIENCE_PACKETPOSITION]));
}


double science_calibration_lmc_record :: GetLMCSignal (enum science_train_data_type datatype, int pixel, 
                                                       enum lmc_signal_term_offset signalterm ) const
{
  double signalvalue = SCIENCE_MISSING_VALUE;

  if (datatype == WARM_DATA_TYPE) 
    signalvalue = signalsI [pixel] [signalterm];
  else if (datatype == HOT_DATA_TYPE)
    signalvalue = signalsII [pixel] [signalterm];

  return signalvalue;
}


double science_calibration_lmc_record :: GetLMCSectorSignal (enum science_train_data_type datatype, int pixel, 
                                                             enum sector_signal_term_offset secsignalterm ) const
{
  double signalvalue = SCIENCE_MISSING_VALUE;

  if (datatype == WARM_DATA_TYPE) 
    signalvalue = sectorsignalsI [pixel] [secsignalterm];
  else if (datatype == HOT_DATA_TYPE)
    signalvalue = sectorsignalsII [pixel] [secsignalterm];

  return signalvalue;
}


void science_calibration_lmc_record :: SetLMCSignals (enum science_train_data_type datatype, 
                                double signals [SCIENCE_PIXELS] [LMC_SIGNAL_TERMS],
				double secsignals [SCIENCE_PIXELS] [SECTOR_SIGNAL_TERMS])
{
  if (datatype == WARM_DATA_TYPE) {
    (void) memcpy ((void*) signalsI, (const void*) signals,  sizeof (double [SCIENCE_PIXELS] [LMC_SIGNAL_TERMS]));
    (void) memcpy ((void*) sectorsignalsI, (const void*) secsignals,  sizeof (double [SCIENCE_PIXELS] [SECTOR_SIGNAL_TERMS]));
  }
  else if (datatype == HOT_DATA_TYPE) {
    (void) memcpy ((void*) signalsII, (const void*) signals,  sizeof (double [SCIENCE_PIXELS] [LMC_SIGNAL_TERMS]));
    (void) memcpy ((void*) sectorsignalsII, (const void*) secsignals,  sizeof (double [SCIENCE_PIXELS] [SECTOR_SIGNAL_TERMS]));
  }
}

  
double science_calibration_lmc_record :: GetLMCSignal (enum science_channel_number channelnumber, int pixel, 
                                                       enum lmc_signal_term_offset signalterm) const
{
  double signalvalue;

  if (channelnumber == CHANNEL_I)
    signalvalue = signalsI [pixel] [signalterm];
  else
    signalvalue = signalsII [pixel] [signalterm];

  return signalvalue;
}


double science_calibration_lmc_record :: GetLMCSectorSignal (enum science_channel_number channelnumber, int pixel, 
                                                             enum sector_signal_term_offset secsignalterm) const
{
  double signalvalue;

  if (channelnumber == CHANNEL_I)
    signalvalue = sectorsignalsI [pixel] [secsignalterm];
  else
    signalvalue = sectorsignalsII [pixel] [secsignalterm];

  return signalvalue;
}


void science_calibration_lmc_record :: SetLMCSignals (enum science_channel_number channelnumber, 
                           double signals [SCIENCE_PIXELS] [LMC_SIGNAL_TERMS],
			   double secsignals [SCIENCE_PIXELS] [SECTOR_SIGNAL_TERMS] ) 
{
  if (channelnumber == CHANNEL_I) {
    (void) memcpy ((void*) signalsI, (const void*) signals, sizeof (double [SCIENCE_PIXELS] [LMC_SIGNAL_TERMS]));
    (void) memcpy ((void*) sectorsignalsI, (const void*) secsignals, sizeof (double [SCIENCE_PIXELS] [SECTOR_SIGNAL_TERMS]));
  }
  else {
    (void) memcpy ((void*) signalsII, (const void*) signals, sizeof (double [SCIENCE_PIXELS] [LMC_SIGNAL_TERMS]));
    (void) memcpy ((void*) sectorsignalsII, (const void*) secsignals, sizeof (double [SCIENCE_PIXELS] [SECTOR_SIGNAL_TERMS]));
  }
}


void science_calibration_lmc_record :: SetRecordData (unsigned short recordcount, float recordtemp, int recordday, 
                             int recordstartmsecs, int recordstopmsecs, unsigned short recordshadowflag,
                             double recordsignalsI [SCIENCE_PIXELS] [LMC_SIGNAL_TERMS],
                             double recordsignalsII [SCIENCE_PIXELS] [LMC_SIGNAL_TERMS], 
                             double recordsecsignalsI [SCIENCE_PIXELS] [SECTOR_SIGNAL_TERMS],
                             double recordsecsignalsII [SCIENCE_PIXELS] [SECTOR_SIGNAL_TERMS] )
{
  SetHeaderInfo (recordcount, recordtemp, recordday, recordstartmsecs, recordstopmsecs, recordshadowflag);
  SetLMCSignals (CHANNEL_I,  recordsignalsI, recordsecsignalsI );
  SetLMCSignals (CHANNEL_II, recordsignalsII, recordsecsignalsII);
}
