/********** ScienceCalibrationLMCPMCRecord.h **************************************************************************\

 $Header$

 REVISION HISTORY
   11/99   Charles Cavanaugh
   11/00   Charles Cavanaugh
   02/02   Debbie Mao
   04/02   Debbie Mao
   05/02   Debbie Mao

 $Log$

\**********************************************************************************************************************/

#if !defined _MOPITT_L1_SCIENCE_CALIBRATION_LMCPMC_RECORD_

  #define _MOPITT_L1_SCIENCE_CALIBRATION_LMCPMC_RECORD_

  #include "ScienceCalibrationRecord.h"

  class science_calibration_lmcpmc_record : public science_calibration_record {
    private :
      double signalsI  [SCIENCE_PIXELS] [PMC_SIGNAL_TERMS];
      double signalsII [SCIENCE_PIXELS] [LMC_SIGNAL_TERMS];
      double sectorsignalsI  [SCIENCE_PIXELS] [SECTOR_SIGNAL_TERMS];
      double sectorsignalsII [SCIENCE_PIXELS] [SECTOR_SIGNAL_TERMS];
      double coldcalsignals  [SCIENCE_PACKETPOSITION] [SCIENCE_PIXELS] [PMC_SIGNAL_STATES];
      double warmcalstddev   [SCIENCE_PIXELS] [WARMCAL_STDDEV_TERMS] [SCIENCE_PACKETPOSITION];

    protected :

    public :
      science_calibration_lmcpmc_record ();
      ~science_calibration_lmcpmc_record ();

      void   GetRecordData (unsigned short&, float&, int&, int&, int&, unsigned short&,
                            double [SCIENCE_PIXELS] [PMC_SIGNAL_TERMS], double [SCIENCE_PIXELS] [LMC_SIGNAL_TERMS],
                            double [SCIENCE_PIXELS] [SECTOR_SIGNAL_TERMS],
			    double [SCIENCE_PIXELS] [SECTOR_SIGNAL_TERMS],
                            double [SCIENCE_PACKETPOSITION] [SCIENCE_PIXELS] [PMC_SIGNAL_STATES],
			    double [SCIENCE_PIXELS] [WARMCAL_STDDEV_TERMS] [SCIENCE_PACKETPOSITION]) const;
      double GetLMCSignal  (enum science_train_data_type datatype, int pixel, enum lmc_signal_term_offset signalterm) 
                            const {return ((datatype == HOT_DATA_TYPE) ? signalsII [pixel] [signalterm] : 
                                           SCIENCE_MISSING_VALUE);}
      double GetLMCSignal  (int pixel, enum lmc_signal_term_offset signalterm) const 
                            {return signalsII [pixel] [signalterm];}

      double GetLMCSectorSignal  (enum science_train_data_type datatype, int pixel, 
				  enum sector_signal_term_offset secsignalterm)  const
	                         {return ((datatype == HOT_DATA_TYPE) ? sectorsignalsII [pixel] [secsignalterm] : 
                                           SCIENCE_MISSING_VALUE);}
      double GetLMCSectorSignal  (int pixel, enum sector_signal_term_offset secsignalterm) const 
                                 {return sectorsignalsII [pixel] [secsignalterm];}
      double GetWarmStddev       ( int, int, enum warmcal_stddev_term_offset ) const ;

      double GetPMCSignal  (int pixel, enum pmc_signal_term_offset signalterm) const
                            {return signalsI [pixel] [signalterm];}

      void   SetLMCSignals (double [SCIENCE_PIXELS] [LMC_SIGNAL_TERMS], double [SCIENCE_PIXELS] [SECTOR_SIGNAL_TERMS]);
      void   SetPMCSignals (double [SCIENCE_PIXELS] [PMC_SIGNAL_TERMS],
                            double [SCIENCE_PIXELS] [WARMCAL_STDDEV_TERMS] [SCIENCE_PACKETPOSITION]);   
      void   SetRecordData (unsigned short, float, int, int, int, unsigned short,
                            double [SCIENCE_PIXELS] [PMC_SIGNAL_TERMS], double [SCIENCE_PIXELS] [LMC_SIGNAL_TERMS],
                            double [SCIENCE_PIXELS] [SECTOR_SIGNAL_TERMS],
                            double [SCIENCE_PACKETPOSITION] [SCIENCE_PIXELS] [PMC_SIGNAL_STATES],
			    double [SCIENCE_PIXELS] [WARMCAL_STDDEV_TERMS] [SCIENCE_PACKETPOSITION]) ;

      void   GetPMCColdSignals (double [SCIENCE_PACKETPOSITION] [SCIENCE_PIXELS] [PMC_SIGNAL_STATES]) const ;
      void   SetPMCColdSignals (double [SCIENCE_PACKETPOSITION] [SCIENCE_PIXELS] [PMC_SIGNAL_STATES] );

  };

#endif
