/********** ScienceCalibrationLMCPMCRecord.C **************************************************************************\

 $Header$

 REVISION HISTORY
   11/99   Charles Cavanaugh
   11/00   Charles Cavanaugh
   02/02   Debbie Mao
   04/02   Debbie Mao
   05/02   Debbie Mao

 $Log$

\**********************************************************************************************************************/

#include "ScienceCalibrationLMCPMCRecord.h"
#include <memory.h>

science_calibration_lmcpmc_record :: science_calibration_lmcpmc_record ()
                                   : science_calibration_record ()
{
  for ( int pixel = 0; pixel < SCIENCE_PIXELS; pixel++ ) {
    for ( int secterm = 0; secterm < SECTOR_SIGNAL_TERMS; secterm++ )
      sectorsignalsI [pixel][secterm] = SCIENCE_MISSING_VALUE;
    for ( int position = 0; position < SCIENCE_PACKETPOSITION; position++ ) {
      for ( int state = 0; state < PMC_SIGNAL_STATES; state++ )
	coldcalsignals [position][pixel][state] = SCIENCE_MISSING_VALUE;
      for ( int posterm = 0; posterm < WARMCAL_STDDEV_TERMS; posterm++ ) 
	warmcalstddev [pixel][posterm][position] = SCIENCE_MISSING_VALUE;
    }
  }
}


science_calibration_lmcpmc_record :: ~science_calibration_lmcpmc_record ()
{
  ;
}


double science_calibration_lmcpmc_record :: GetWarmStddev ( int pos, int pixel, 
							    enum warmcal_stddev_term_offset warmsignalterm ) const
{
  double signalvalue = SCIENCE_MISSING_VALUE;

  signalvalue = warmcalstddev   [pixel] [warmsignalterm] [pos];

  return signalvalue;
}


void science_calibration_lmcpmc_record :: GetRecordData (unsigned short& recordcount, float& recordtemp, int& recordday,
        int& recordstartmsecs, int& recordstopmsecs, unsigned short& recordshadowflag,
        double recordsignalsI [SCIENCE_PIXELS] [PMC_SIGNAL_TERMS],
        double recordsignalsII [SCIENCE_PIXELS] [LMC_SIGNAL_TERMS],
	double recordsecsignalsI  [SCIENCE_PIXELS] [SECTOR_SIGNAL_TERMS],
	double recordsecsignalsII [SCIENCE_PIXELS] [SECTOR_SIGNAL_TERMS],
        double recordcoldsignals [SCIENCE_PACKETPOSITION] [SCIENCE_PIXELS] [PMC_SIGNAL_STATES],
        double recordwarmsignals [SCIENCE_PIXELS] [WARMCAL_STDDEV_TERMS] [SCIENCE_PACKETPOSITION] )  const
{
  GetHeaderInfo (recordcount, recordtemp, recordday, recordstartmsecs, recordstopmsecs, recordshadowflag);
  (void) memcpy ((void*) recordsignalsI,  (const void*) signalsI,  sizeof (double [SCIENCE_PIXELS] [PMC_SIGNAL_TERMS]));
  (void) memcpy ((void*) recordsignalsII, (const void*) signalsII, sizeof (double [SCIENCE_PIXELS] [LMC_SIGNAL_TERMS]));
  (void) memcpy ((void*) recordsecsignalsI,  (const void*) sectorsignalsI,  
		                              sizeof (double [SCIENCE_PIXELS] [SECTOR_SIGNAL_TERMS]));
  (void) memcpy ((void*) recordsecsignalsII,  (const void*) sectorsignalsII,  
		                              sizeof (double [SCIENCE_PIXELS] [SECTOR_SIGNAL_TERMS]));
  (void) memcpy ((void*) recordcoldsignals , (const void*) coldcalsignals, 
                         sizeof (double [SCIENCE_PACKETPOSITION] [SCIENCE_PIXELS] [PMC_SIGNAL_STATES]));
  (void) memcpy ((void*) recordwarmsignals, (const void*) warmcalstddev, 
                         sizeof (double [SCIENCE_PIXELS] [WARMCAL_STDDEV_TERMS] [SCIENCE_PACKETPOSITION]));
}


void science_calibration_lmcpmc_record :: SetLMCSignals (double signals [SCIENCE_PIXELS] [LMC_SIGNAL_TERMS],
                              double secsignals [SCIENCE_PIXELS] [SECTOR_SIGNAL_TERMS] )
{
  (void) memcpy ((void*) signalsII, (const void*) signals, sizeof (double [SCIENCE_PIXELS] [LMC_SIGNAL_TERMS]));
  (void) memcpy ((void*) sectorsignalsII, (const void*) secsignals, sizeof (double [SCIENCE_PIXELS] [SECTOR_SIGNAL_TERMS]));
}


void science_calibration_lmcpmc_record :: SetPMCSignals (double signals [SCIENCE_PIXELS] [PMC_SIGNAL_TERMS],
                              double warmsignals [SCIENCE_PIXELS] [WARMCAL_STDDEV_TERMS] [SCIENCE_PACKETPOSITION] )
{
  (void) memcpy ((void*) signalsI, (const void*) signals, sizeof (double [SCIENCE_PIXELS] [PMC_SIGNAL_TERMS]));
  (void) memcpy ((void*) warmcalstddev, (const void*) warmsignals, 
                         sizeof (double [SCIENCE_PIXELS] [WARMCAL_STDDEV_TERMS] [SCIENCE_PACKETPOSITION]) );
}


void science_calibration_lmcpmc_record :: SetRecordData (unsigned short recordcount, float recordtemp, int recordday,
            int recordstartmsecs, int recordstopmsecs, unsigned short recordshadowflag,
            double recordsignalsI [SCIENCE_PIXELS] [PMC_SIGNAL_TERMS],
            double recordsignalsII [SCIENCE_PIXELS] [LMC_SIGNAL_TERMS],
	    double recordsecsignalsII [SCIENCE_PIXELS] [SECTOR_SIGNAL_TERMS],
	    double recordcoldsignals [SCIENCE_PACKETPOSITION] [SCIENCE_PIXELS] [PMC_SIGNAL_STATES],
	    double recordwarmsignals [SCIENCE_PIXELS] [WARMCAL_STDDEV_TERMS] [SCIENCE_PACKETPOSITION])
{
  SetHeaderInfo (recordcount, recordtemp, recordday, recordstartmsecs, recordstopmsecs, recordshadowflag);
  SetPMCSignals (recordsignalsI, recordwarmsignals);
  SetLMCSignals (recordsignalsII,recordsecsignalsII);
  SetPMCColdSignals (recordcoldsignals);
}


void science_calibration_lmcpmc_record :: GetPMCColdSignals 
                   (double signals [SCIENCE_PACKETPOSITION] [SCIENCE_PIXELS] [PMC_SIGNAL_STATES]) const
{
  (void) memcpy ((void*) signals, (const void*) coldcalsignals, 
                         sizeof (double [SCIENCE_PACKETPOSITION] [SCIENCE_PIXELS] [PMC_SIGNAL_STATES]));
}


void science_calibration_lmcpmc_record :: SetPMCColdSignals 
                   (double signals [SCIENCE_PACKETPOSITION] [SCIENCE_PIXELS] [PMC_SIGNAL_STATES])
{
  (void) memcpy ((void*) coldcalsignals, (const void*) signals, 
                         sizeof (double [SCIENCE_PACKETPOSITION] [SCIENCE_PIXELS] [PMC_SIGNAL_STATES]));
}

