/********** TimeSwitch.C **********************************************************************************************\

 $Header$

 REVISION HISTORY
   01/99   Charles Cavanaugh
   09/99   Charles Cavanaugh

 $Log$

\**********************************************************************************************************************/

#include "TimeSwitch.h"

time_switch :: time_switch ()
             : parameter_switch (),
               time ()
{
  daylogical = 0;
  msecslogical = 0;
}


time_switch :: time_switch (PGSt_PC_Logical day, PGSt_PC_Logical msecs)
             : parameter_switch (),
               time ()
{
  daylogical = day;
  msecslogical = msecs;
}


time_switch :: ~time_switch ()
{
  ;
}


bool time_switch :: Read ()
{
  bool isread = false;

  int day, msecs;
  if (parameter_switch::Read (daylogical, day) && parameter_switch::Read (msecslogical, msecs)) {
    time.Set (day, msecs);
    isread = true;
  }

  return isread;
}
