/********** ProcessorParameters.h *************************************************************************************\

 $Header$

 REVISION HISTORY
   01/99   Charles Cavanaugh
   09/99   Charles Cavanaugh
   09/01   Debbie Mao
   08/02   Debbie Mao

 $Log$

\**********************************************************************************************************************/

#if !defined _MOPITT_L1_PROCESSOR_PARAMETERS_

  #define _MOPITT_L1_PROCESSOR_PARAMETERS_

  #include "TimeSwitch.h"
  #include "ChopperSwitch.h"
  #include "Ch7Switch.h"
  #include "GranuleSwitch.h"
  #include "PixelSwitch.h"

  class processor_parameters {
    private :
      static int const START_DAY_LOGICAL;
      static int const START_MSECS_LOGICAL;
      static int const STOP_DAY_LOGICAL;
      static int const STOP_MSECS_LOGICAL;
      static int const CHOPPER_OK_LOGICAL;
      static int const CH7_NEWOLD_LOGICAL;
      static int const BAD_GRANULE_LOGICAL;
      static int const BAD_PIXEL_LOGICAL;

      time_switch starttime;
      time_switch stoptime;
      chopper_switch chopperswitch;
      ch7_switch ch7switch;
      granule_switch granuleswitch;
      pixel_switch pixelswitch;

    protected :

    public :
      processor_parameters ();
      ~processor_parameters ();

      bool         Read        ();
      mopitt_time  const& GetStartTime () const {return starttime.GetTime ();}
      mopitt_time  const& GetStopTime  () const {return stoptime.GetTime ();}
      int const&   GetChopper  () const {return chopperswitch.GetChopper ();}
      int const&   GetCh7Info  () const {return ch7switch.GetCh7Info ();}

      int  const&  GetBadGranuleNumber () const {return granuleswitch.GetBadGranuleNumber ();}
      void         GetBadStartTime (  int [MAX_GRANULE] ) const ;
      void         GetBadStopTime  (  int [MAX_GRANULE] ) const ;
      int  const&  GetBadPixelNumber   () const {return pixelswitch.GetBadPixelNumber ();}
      void         GetBadPixel     ( int [MAX_CHANNEL] [MAX_GRANULE] [MAX_PIXEL] ) const ;
  };

#endif
