/********** ProcessorParameters.C *************************************************************************************\

 $Header$

 REVISION HISTORY
   01/99   Charles Cavanaugh
   09/99   Charles Cavanaugh
   09/01   Debbie Mao
   08/02   Debbie Mao

 $Log$

\**********************************************************************************************************************/

#include "ProcessorParameters.h"

int const processor_parameters::START_DAY_LOGICAL   = 41901;
int const processor_parameters::START_MSECS_LOGICAL = 41902;
int const processor_parameters::STOP_DAY_LOGICAL    = 41903;
int const processor_parameters::STOP_MSECS_LOGICAL  = 41904;
int const processor_parameters::CHOPPER_OK_LOGICAL  = 41905;
int const processor_parameters::CH7_NEWOLD_LOGICAL  = 41906;
int const processor_parameters::BAD_GRANULE_LOGICAL = 41907;
int const processor_parameters::BAD_PIXEL_LOGICAL   = 41908;

processor_parameters :: processor_parameters ()
                      : starttime (START_DAY_LOGICAL, START_MSECS_LOGICAL),
                        stoptime (STOP_DAY_LOGICAL, STOP_MSECS_LOGICAL),
			chopperswitch (CHOPPER_OK_LOGICAL),
			ch7switch (CH7_NEWOLD_LOGICAL),
			granuleswitch (BAD_GRANULE_LOGICAL),
			pixelswitch (BAD_PIXEL_LOGICAL)
{
  ;
}


processor_parameters :: ~processor_parameters ()
{
  ;
}


bool processor_parameters :: Read ()
{
  return (starttime.Read () && stoptime.Read () && chopperswitch.Read() && ch7switch.Read() &&
          granuleswitch.Read() && pixelswitch.Read() );
}


void processor_parameters :: GetBadStartTime ( int start [MAX_GRANULE] ) const
{
  granuleswitch.GetBadStartTime ( start );
}


void processor_parameters :: GetBadStopTime ( int stop [MAX_GRANULE] ) const
{
  granuleswitch.GetBadStopTime ( stop );
}


void processor_parameters :: GetBadPixel ( int badpixel [MAX_CHANNEL] [MAX_GRANULE] [MAX_PIXEL] ) const
{
  pixelswitch.GetBadPixel ( badpixel );
}
