/********** PixelSwitch.C*********************************************************************************************\

 $Header$

 REVISION HISTORY
   08/02  Debbie Mao

 $Log$

\**********************************************************************************************************************/

#include "PixelSwitch.h"
#include "DiagnosticReporter.h"

extern diagnostic_reporter diagnosticreporter;

int const pixel_switch::INFO_ERROR = 888;

pixel_switch :: pixel_switch ()
              : parameter_switch (),
                pixelinfo()
{
  badpixellogical = 0;
}


pixel_switch :: pixel_switch (PGSt_PC_Logical pixel)
              : parameter_switch (),
                pixelinfo()
{
  badpixellogical = pixel;
}


pixel_switch :: ~pixel_switch ()
{
  ;
}


void pixel_switch :: GetBadPixel ( int bad [MAX_CHANNEL] [MAX_GRANULE] [MAX_PIXEL] )  const
{
  (void) memcpy ( (void*) bad, (const void*) badpixel, sizeof (
		  int [MAX_CHANNEL] [MAX_GRANULE] [MAX_PIXEL] ) );
}


bool pixel_switch :: Read ()
{
  bool isread = false;
  string pixelno;

  if (parameter_switch::Read (badpixellogical, pixelno) )
 {   
   SetPixel (pixelno); 	
   ConvertPixelInfo ();
   isread = true;
  }

  return isread;
}

void pixel_switch :: ConvertPixelInfo ()
{ 
  int i, j, k, pixlen;
  string cpn [MAX_GRANULE], cpnum [MAX_PIXEL];
  int pnum[MAX_PIXEL];

  //initial badpixel
  for (k=0; k<MAX_CHANNEL; k++) 
    for (i=0; i<MAX_GRANULE; i++) 
      for (j=0; j<MAX_PIXEL; j++ )
        badpixel [k] [i] [j] = -9999;

  //Get pixel info in each bad granule group in string
  pixlen = pixelinfo.length ();
  j = 0;
  for ( i=0; i< pixlen; i=i+4 ) {
    cpn[j] = pixelinfo.substr(i,4);
    j++;
  }

  if ( cpn[0] == "xxxx" )
    badpixgrpnum = 0;
  else {
    badpixgrpnum = j;    
    
    //get pixel information for exch granule
    for (j=0; j < badpixgrpnum; j++ ) {

      for ( k=0; k<MAX_PIXEL; k++) {

	cpnum[k] = cpn[j].substr(k,1);
	pnum[k]  = atoi ( cpnum[k].c_str() );
	
	if ( k == 0 ) 
	  switch ( pnum[k] ) {
	  case 1:  badpixel [3] [j] [3] = 1;
	    break;
	  case 2:  badpixel [7] [j] [0] = 1;
	    break;
	  case 3:  badpixel [3] [j] [3] = 1;
	           badpixel [7] [j] [0] = 1;
	    break;
	  }
	if ( k == 1 ) 
	  switch ( pnum[k] ) {
	  case 1:  badpixel [3] [j] [0] = 1;
	    break;
	  case 2:  badpixel [7] [j] [3] = 1;
	    break;
	  case 3:  badpixel [3] [j] [0] = 1;
	           badpixel [7] [j] [3] = 1;
	    break;
	  }
	if ( k == 2 ) 
	  switch ( pnum[k] ) {
	  case 1:  badpixel [3] [j] [1] = 1;
	    break;
	  case 2:  badpixel [7] [j] [2] = 1;
	    break;
	  case 3:  badpixel [3] [j] [1] = 1;
	           badpixel [7] [j] [2] = 1;
	    break;
	  }
	if ( k == 3 )
	  switch ( pnum[k] ) {
	  case 1:  badpixel [3] [j] [2] = 1;
	    break;
	  case 2:  badpixel [7] [j] [1] = 1;
	    break;
	  case 3:  badpixel [3] [j] [2] = 1;
	           badpixel [7] [j] [1] = 1;
	    break;
	  }
      }  
    } 
  }
}
