/********** ParameterSwitch.C *****************************************************************************************\

 $Header$

 REVISION HISTORY
   01/99   Charles Cavanaugh
   09/99   Charles Cavanaugh
   08/02   Debbie Mao

 $Log$

\**********************************************************************************************************************/

#include "ParameterSwitch.h"
#include "DiagnosticReporter.h"
#include <string.h>

extern diagnostic_reporter diagnosticreporter;

int const parameter_switch::READ_ERROR = 900;

parameter_switch :: parameter_switch ()
{
  ;
}


parameter_switch :: ~parameter_switch ()
{
  ;
}


bool parameter_switch :: Read (PGSt_PC_Logical logical, int& intvalue)
{
  bool isread = false;

  // read the logical's value and convert them
  char switchchars [PGSd_PC_VALUE_LENGTH_MAX];
  if (PGS_PC_GetConfigData (logical, switchchars) != PGS_S_SUCCESS) 
    diagnosticreporter.AddEntry (DIAGNOSTICS_ERROR, DIAGNOSTICS_PARAMETERS_MODULE, READ_ERROR, logical, 0, 0, 0, 0, 0, 
                                 0, 0, "Could not read runtime parameter");
  else {
    intvalue = atoi (switchchars);
    isread = true;
  }

  return isread;
}


bool parameter_switch :: Read (PGSt_PC_Logical logical, string& stringvalue)
{
  bool isread = false;

  // read the logical's value and convert them
  char switchchars [PGSd_PC_VALUE_LENGTH_MAX];
  if (PGS_PC_GetConfigData (logical, switchchars) != PGS_S_SUCCESS) 
    diagnosticreporter.AddEntry (DIAGNOSTICS_ERROR, DIAGNOSTICS_PARAMETERS_MODULE, READ_ERROR, logical, 0, 0, 0, 0, 0, 
                                 0, 0, "Could not read runtime parameter");
  else {
    stringvalue = switchchars;
    
    isread = true;
  }

  return isread;
}
