/********** GrannuleSwitch.C*********************************************************************************************\

 $Header$

 REVISION HISTORY
   08/02  Debbie Mao

 $Log$

\**********************************************************************************************************************/

#include "GranuleSwitch.h"


granule_switch :: granule_switch ()
                : parameter_switch (),
                  granuleinfo()
{
  badgranulelogical = 0;
}


granule_switch :: granule_switch (PGSt_PC_Logical granule)
                : parameter_switch (),
                  granuleinfo()
{
  badgranulelogical = granule;
}


granule_switch :: ~granule_switch ()
{
  ;
}


bool granule_switch :: Read ()
{
  bool isread = false;

  string granuleno;
  if (parameter_switch::Read (badgranulelogical, granuleno) )
 {
    SetGranule (granuleno);
    ConvertGranuleInfo ();
    isread = true;
  }

  return isread;
}


void granule_switch :: ConvertGranuleInfo ( )
{
  int i, j, gralen;
  string cgt[MAX_GRANULE];
  int gt[MAX_GRANULE];

  for (i=0; i<MAX_GRANULE; i++ ) {
    badstarttime[i] = -9999;
    badstoptime[i]  = -9999;
  }

  //Get each bad granule number in string
  gralen = granuleinfo.length();
  j = 0;
  for (i=0; i< gralen; i=i+2 ) {
    cgt[j] = granuleinfo.substr(i,2);
    j++;
  }

  if ( cgt[0] == "xx" )
    badgranum = 0 ;
  else 
    badgranum = j;

  //convert bad granule from string into int and calculate each granule start/stop time
  for ( j=0; j < badgranum; j++ ) {
    gt[j]  = atoi ( cgt[j].c_str () );  
    badstarttime[j] = gt[j] * 60 * 60 * 1000;
    badstoptime[j] = ( gt[j] + 2 ) * 60 * 60 * 1000; 
  }
}


void granule_switch :: GetBadStartTime (int start [MAX_GRANULE] ) const
{
  (void) memcpy ((void*) start, (const void*) badstarttime, sizeof (int [MAX_GRANULE])  );
}


void granule_switch :: GetBadStopTime (int stop [MAX_GRANULE] ) const
{
  (void) memcpy ((void*) stop, (const void*) badstoptime, sizeof (int [MAX_GRANULE])  );
}

