/********** MOPQ1Metadata.C *******************************************************************************************\

 $Header$

 REVISION HISTORY
   06/99  Tom Lauren
   08/99  Charles Cavanaugh

 $Log$

\**********************************************************************************************************************/

#include "MOPQ1Metadata.h"
#include "GlobalMetadata.h"

extern global_metadata globalmetadata;

PGSt_PC_Logical const mopq1_metadata::MOPQ1_MCF_FILELOGICAL = 41701;
PGSt_PC_Logical const mopq1_metadata::MOPQ1_MET_FILELOGICAL = 41702;

mopq1_metadata :: mopq1_metadata ()
                : ascii_metadata ()
{
  ;
}


mopq1_metadata :: mopq1_metadata (PGSt_PC_Logical asciifilelogical)
                : ascii_metadata (MOPQ1_MCF_FILELOGICAL)
{
  Set (asciifilelogical);
}


mopq1_metadata :: ~mopq1_metadata ()
{
  ;
}


bool mopq1_metadata :: Set (PGSt_PC_Logical asciifilelogical)
{
  bool isset = false;

  if (Initialize ())
    if (mopq1metadatagroups.Set (asciifilelogical, globalmetadata.GetStartTime (), globalmetadata.GetStopTime (), 
                                 GetHandle ()))
      isset = true;

  return isset;
}


bool mopq1_metadata :: Write ()
{
  return ascii_metadata::Write (MOPQ1_MET_FILELOGICAL);
}
