/********** MOPIRTable.h **********************************************************************************************\

 $Header$

 REVISION HISTORY
   12/98   Charles Cavanaugh
   04/99   Tom Lauren
   09/99   Charles Cavanaugh
   05/00   Daniel Ziskin

 $Log$

\**********************************************************************************************************************/

#if !defined _MOPITT_L1_MOPIR_TABLE_

  #define _MOPITT_L1_MOPIR_TABLE_

  #include <string>

  using namespace std;

  int const MOPIR_RADS = 221;

  enum mopir_channel_code { CHANNEL7_AVERAGE,    CHANNEL3_AVERAGE,    CHANNEL1_AVERAGE,    CHANNEL5_AVERAGE, 
                            CHANNEL7_DIFFERENCE, CHANNEL3_DIFFERENCE, CHANNEL1_DIFFERENCE, CHANNEL5_DIFFERENCE, 
                            CHANNEL2_AVERAGE,    CHANNEL6_AVERAGE,    CHANNEL2_DIFFERENCE, CHANNEL6_DIFFERENCE,
                            CHANNEL4_AVERAGE,    CHANNEL8_AVERAGE,    CHANNEL4_DIFFERENCE, CHANNEL8_DIFFERENCE };

  enum mopir_table_part { TEMPERATURE_PART, RADIANCE_PART };

  enum mopir_radiance_type { RADIANCE_AVERAGE, RADIANCE_DIFFERENCE };
  
  class mopir_table {
    private :
      static int const MOPIR_CHANNELS = 16;
      static int const PARSE_ERROR;
      static int const OUT_OF_RANGE_WARNING;
      static int const NOT_IN_RANGE_WARNING;
      static int const RETRIEVE_WARNING;

      float temps [MOPIR_RADS];
      float rads [MOPIR_CHANNELS][MOPIR_RADS];

      bool BuildChannelCode    (int, enum mopir_radiance_type, enum mopir_channel_code&) const;
      bool GetTemperatureIndex (float, int&) const;
    
    protected :

    public :
      mopir_table ();
      ~mopir_table ();

      bool GetRadiance (float, int, enum mopir_radiance_type, float&) const;
      bool Parse       (string const&, enum mopir_table_part, enum mopir_channel_code);
  };

#endif
