/********** MOPIRFile.C ***********************************************************************************************\

 $Header$

 REVISION HISTORY
   12/98   Charles Cavanaugh
   04/99   Tom Lauren
   09/99   Charles Cavanaugh
   05/00   Daniel Ziskin
   09/00   Charles Cavanaugh

 $Log$

\**********************************************************************************************************************/

#include "MOPIRFile.h"
#include "DiagnosticReporter.h"
#include <iostream>

int const mopir_file::READ_ERROR             = 900;
int const mopir_file::RETRIEVE_ERROR         = 901;
int const mopir_file::MOPIR_FILE_MAXLINESIZE = 256;

extern diagnostic_reporter diagnosticreporter;

mopir_file :: mopir_file (PGSt_PC_Logical filelogical)
            : ascii_read_file (filelogical, MOPIR_FILE_MAXLINESIZE)
            , table ()
{
  tableread = false;
  Open ();
}


mopir_file :: ~mopir_file ()
{
  Close ();
}


bool mopir_file :: ReadPlanck (mopir_table_part part, mopir_channel_code channel)
{
  bool isread = true;

  // Read one temperature or radiance portion of the file and store that portion in an extensible format.
  int radlines = 0;
  string ioentry; 
  while (ascii_read_file::Read (ioentry) && radlines < MOPIR_RADS)
    if (ioentry [0] != '!')
      if (table.Parse (ioentry, part, channel))
        radlines++;

  if (radlines != MOPIR_RADS) {
    isread = false;
    char channelchars [10];
    (void) sprintf (channelchars, "%d", (int) channel);
    string message = "Could not read in all radiance values for channel code ";
    message += channelchars;
    diagnosticreporter.AddEntry (DIAGNOSTICS_ERROR, DIAGNOSTICS_MOPIR_MODULE, READ_ERROR, 0, 0, 0, 0, 0, 0, 0, 0,
                                 message);
  }

  return isread;
}


bool mopir_file :: Read ()
{
  bool isread = false;

  // Read the temperature portion of the file (the channel code CHANNEL1_AVERAGE will be ignored here).
  if (ReadPlanck (TEMPERATURE_PART, CHANNEL1_AVERAGE))

    // Read the radiance portions of the file.
    if (ReadPlanck (RADIANCE_PART, CHANNEL7_AVERAGE))
      if (ReadPlanck (RADIANCE_PART, CHANNEL3_AVERAGE))
        if (ReadPlanck (RADIANCE_PART, CHANNEL1_AVERAGE))
          if (ReadPlanck (RADIANCE_PART, CHANNEL5_AVERAGE))
            if (ReadPlanck (RADIANCE_PART, CHANNEL7_DIFFERENCE))
              if (ReadPlanck (RADIANCE_PART, CHANNEL3_DIFFERENCE))
                if (ReadPlanck (RADIANCE_PART, CHANNEL1_DIFFERENCE))
                  if (ReadPlanck (RADIANCE_PART, CHANNEL5_DIFFERENCE))
                    if (ReadPlanck (RADIANCE_PART, CHANNEL2_AVERAGE))
                      if (ReadPlanck (RADIANCE_PART, CHANNEL6_AVERAGE))
                        if (ReadPlanck (RADIANCE_PART, CHANNEL2_DIFFERENCE))
                          if (ReadPlanck (RADIANCE_PART, CHANNEL6_DIFFERENCE))
                            if (ReadPlanck (RADIANCE_PART, CHANNEL4_AVERAGE))
                              if (ReadPlanck (RADIANCE_PART, CHANNEL8_AVERAGE))
                                if (ReadPlanck (RADIANCE_PART, CHANNEL4_DIFFERENCE))
                                  if (ReadPlanck (RADIANCE_PART, CHANNEL8_DIFFERENCE)) {
                                    isread = true;
                                    tableread = true;
                                  }
                                
  return isread;
}


bool mopir_file :: GetRadiance (float temp, int channel, enum mopir_radiance_type radtype, float& radiance) const
{
  bool isretrieved = false;

  // Retrieve the radiance for a given temperature, channel, and radiance type.
  if (! tableread)
    diagnosticreporter.AddEntry (DIAGNOSTICS_ERROR, DIAGNOSTICS_MOPIR_MODULE, RETRIEVE_ERROR, 0, 0, 0, 0, 0, 0, 0, 0,
                                 "Cannot retrieve radiance because table values have not been successfully read");
  else if (table.GetRadiance (temp, channel, radtype, radiance))
    isretrieved = true;

  return isretrieved;
}
