/********** MOPIRCollection.C *****************************************************************************************\

 $Header$

 REVISION HISTORY
   09/00   Charles Cavanaugh
   09/01   Debbie Mao

 $Log$

\**********************************************************************************************************************/

#include "MOPIRCollection.h"

mopir_collection :: mopir_collection ()
                  : file0 (MOPIR_FILE_0_LOGICAL)
                  , file1 (MOPIR_FILE_1_LOGICAL)
                  , file2 (MOPIR_FILE_2_LOGICAL)
                  , file3 (MOPIR_FILE_3_LOGICAL)
{
  ;
}


mopir_collection :: ~mopir_collection ()
{
  ;
}


bool mopir_collection :: Read ()
{
  bool isread = false;

  if (file0.Read ())
    if (file1.Read ())
      if (file2.Read ())
        if (file3.Read ())
          isread = true; 

  return isread;
}


bool mopir_collection :: GetRadiance (float temp, int channel, int pixel, enum mopir_radiance_type radtype, 
                                      float& radiance) const
{
  bool isretrieved;

  switch (pixel) {
    case 0 : isretrieved = file0.GetRadiance (temp, channel, radtype, radiance);
             break;
    case 1 : isretrieved = file1.GetRadiance (temp, channel, radtype, radiance);
             break;
    case 2 : isretrieved = file2.GetRadiance (temp, channel, radtype, radiance);
             break;
    case 3 : isretrieved = file3.GetRadiance (temp, channel, radtype, radiance);
             break;
    default : isretrieved = false;
  }

  return isretrieved;
}
