/********** ThermistorPressureTempParameter.C *************************************************************************\

 $Header$

 REVISION HISTORY
   03/99   Charles Cavanaugh
   10/99   Charles Cavanaugh
   05/00   Charles Cavanaugh

 $Log$

\**********************************************************************************************************************/

#include <math.h>
#include <string.h>
#include <stdlib.h>
#include "ThermistorPressureTempParameter.h"

int const thermistor_pressuretemp_parameter::PARAMETER_COUNT = 5;

thermistor_pressuretemp_parameter :: thermistor_pressuretemp_parameter ()
                                   : mopip_parameter ()
{
  bank = 0;
  gain = 0.0;
  offset = 0.0;
  low = 0;
  high = 0;
}


thermistor_pressuretemp_parameter :: ~thermistor_pressuretemp_parameter ()
{
  ;
}


void thermistor_pressuretemp_parameter :: Compute (float sensor [COMPUTE_TERMS], float hiref [COMPUTE_TERMS], 
                                                   float loref [COMPUTE_TERMS], float average [COMPUTE_TERMS]) const
{
  // convert the readings to degrees Kelvin and generate the standard deviation of the temperature
  average [COMPUTE_TERM_AVERAGE] = 273.15 + offset + 
                                            (gain * ((sensor [COMPUTE_TERM_AVERAGE] - loref [COMPUTE_TERM_AVERAGE]) / 
                                                     (hiref [COMPUTE_TERM_AVERAGE] - sensor [COMPUTE_TERM_AVERAGE])));

  double lorefderiv = -gain / (hiref [COMPUTE_TERM_AVERAGE] - sensor [COMPUTE_TERM_AVERAGE]);
  average [COMPUTE_TERM_VARIANCE] = (pow (lorefderiv, 2.0) * loref [COMPUTE_TERM_VARIANCE]) +
                                    (pow ((lorefderiv * (sensor [COMPUTE_TERM_AVERAGE] - loref [COMPUTE_TERM_AVERAGE]) /
                                          (hiref [COMPUTE_TERM_AVERAGE] - sensor [COMPUTE_TERM_AVERAGE])), 2.0) * 
                                          hiref [COMPUTE_TERM_VARIANCE]) +
                           (pow ((lorefderiv * (-1.0 - ((sensor [COMPUTE_TERM_AVERAGE] - loref [COMPUTE_TERM_AVERAGE]) /
                                             (hiref [COMPUTE_TERM_AVERAGE] - sensor [COMPUTE_TERM_AVERAGE])))), 2.0) *
                                    sensor [COMPUTE_TERM_VARIANCE]);
}


void thermistor_pressuretemp_parameter :: GetRange (float& highrange, float& lowrange) const
{
  highrange = high;
  lowrange = low;
}


bool thermistor_pressuretemp_parameter :: Parse (string const& mopipline)
{
  bool isparsed = false;

  // make a copy of the line
  char* linecopy = new char [mopipline.length () + 1];
  (void) strcpy (linecopy, mopipline.c_str ());

  // skip over the value type
  char* token = strtok (linecopy, " ");

  // set the enumerator, based on the sensor name
  string name = strtok (NULL, " ");
  if      (name == "LMC1") enumerator = LMCPressureTemperature1;
  else if (name == "LMC2") enumerator = LMCPressureTemperature2;
  else if (name == "LMC3") enumerator = LMCPressureTemperature3;
  else if (name == "LMC4") enumerator = LMCPressureTemperature4;
  else ReportNameError ("ThermistorPressureTemp", name);

  // read in the values
  int valuecount = 0;
  while ((token = strtok (NULL, " =,[]\n")) != NULL && valuecount < PARAMETER_COUNT) {
    switch (valuecount) {
      case 0 : bank = (short) atoi (token);
               break;
      case 1 : gain = atof (token);
               break;
      case 2 : offset = atof (token);
               break;
      case 3 : low  = (float) atof (token);
               break;
      case 4 : high = (float) atof (token);
               break;
      default : break;
    }

    valuecount++;
  }

  delete [] linecopy;

  if (valuecount == PARAMETER_COUNT)
    isparsed = true;
  else
    ReportValuesError ("ThermistorPressureTemp", name);

  return isparsed;
}
