/********** ThermistorPressureParameter.C *****************************************************************************\

 $Header$

 REVISION HISTORY
   03/98   Charles Cavanaugh
   10/99   Charles Cavanaugh
   05/00   Charles Cavanaugh

 $Log$

\**********************************************************************************************************************/

#include <math.h>
#include <string.h>
#include <stdlib.h>
#include "ThermistorPressureParameter.h"

int const thermistor_pressure_parameter::PARAMETER_COUNT = 7;

thermistor_pressure_parameter :: thermistor_pressure_parameter ()
                               : mopip_parameter ()
{
  bits = 0;
  vH = 0.0;
  vO = 0.0;
  b = 0.0;
  c = 0.0;
  low = 0;
  high = 0;
}


thermistor_pressure_parameter :: ~thermistor_pressure_parameter ()
{
  ;
}


void thermistor_pressure_parameter :: Compute (float sensor [COMPUTE_TERMS], float hiref [COMPUTE_TERMS], 
                                               float loref [COMPUTE_TERMS], float average [COMPUTE_TERMS]) const
{
  // do a bit conversion on the sensor, hi ref and lo ref
  float newsensor, newhiref, newloref;
  BitConvert (bits, sensor [COMPUTE_TERM_AVERAGE], hiref [COMPUTE_TERM_AVERAGE], loref [COMPUTE_TERM_AVERAGE], 
              newsensor, newhiref, newloref);

  // convert the readings to voltage and generate the variance
  double vP = vO + (vH * ((newsensor - newloref) / (newhiref - newloref)));
  double sensorderiv = vH / (newhiref - newloref);
  double vPvariance = (pow (sensorderiv, 2.0) * sensor [COMPUTE_TERM_VARIANCE]) +
                      (pow ((sensorderiv * (newloref - newsensor) / (newhiref - newloref)), 2.0) *
                       hiref [COMPUTE_TERM_VARIANCE]) +
                      (pow ((sensorderiv * (-1.0 + ((newsensor - newloref) / (newhiref - newloref)))), 2.0) *
                       loref [COMPUTE_TERM_VARIANCE]);

  // convert to pressure in kPa and generate the standard deviation of the pressure
  average [COMPUTE_TERM_AVERAGE] = c + (b * vP);
  average [COMPUTE_TERM_VARIANCE] = b * b * vPvariance;
}


void thermistor_pressure_parameter :: GetRange (float& highrange, float& lowrange) const
{
  highrange = high;
  lowrange = low;
}


bool thermistor_pressure_parameter :: Parse (string const& mopipline)
{
  bool isparsed = false;

  // make a copy of the line
  char* linecopy = new char [mopipline.length () + 1];
  (void) strcpy (linecopy, mopipline.c_str ());

  // skip over the value type
  char* token = strtok (linecopy, " ");

  // set the enumerator, based on the sensor name
  string name = strtok (NULL, " ");
  if      (name == "LMC1") enumerator = LMCPressure1;
  else if (name == "LMC2") enumerator = LMCPressure2;
  else if (name == "LMC3") enumerator = LMCPressure3;
  else if (name == "LMC4") enumerator = LMCPressure4;
  else ReportNameError ("ThermistorPressure", name);

  // read in the values
  int valuecount = 0;
  while ((token = strtok (NULL, " =,[]\n")) != NULL && valuecount < PARAMETER_COUNT) {
    switch (valuecount) {
      case 0 : bits = (short) atoi (token);
               break;
      case 1 : vH = atof (token);
               break;
      case 2 : vO = atof (token);
               break;
      case 3 : b = atof (token);
               break;
      case 4 : c = atof (token);
               break;
      case 5 : low = (float) atof (token);
               break;
      case 6 : high = (float) atof (token);
               break;
      default : break;
    }

    valuecount++;
  }

  delete [] linecopy;

  if (valuecount == PARAMETER_COUNT)
    isparsed = true;
  else
    ReportValuesError ("ThermistorPressure", name);

  return isparsed;
}
