/********** PMCPhaseErrorParameter.C **********************************************************************************\

 $Header$

 REVISION HISTORY
   03/99   Charles Cavanaugh
   10/99   Charles Cavanaugh
   05/00   Charles Cavanaugh

 $Log$

\**********************************************************************************************************************/

#include <string.h>
#include <stdlib.h>
#include "PMCPhaseErrorParameter.h"

int const pmc_phaseerror_parameter::PARAMETER_COUNT = 4;

pmc_phaseerror_parameter :: pmc_phaseerror_parameter ()
                          : mopip_parameter ()
{
  gain = 0.0;
  offset = 0.0;
  low = 0;
  high = 0;
}


pmc_phaseerror_parameter :: ~pmc_phaseerror_parameter ()
{
  ;
}


void pmc_phaseerror_parameter :: Compute (float sensor [COMPUTE_TERMS], float average [COMPUTE_TERMS]) const
{
  // convert the sensor to percentage
  average [COMPUTE_TERM_AVERAGE] = 100.0 - (offset + (gain * sensor [COMPUTE_TERM_AVERAGE]));
  average [COMPUTE_TERM_VARIANCE] = gain * gain * sensor [COMPUTE_TERM_VARIANCE];
}


void pmc_phaseerror_parameter :: GetRange (float& highrange, float& lowrange) const
{
  highrange = high;
  lowrange = low;
}


bool pmc_phaseerror_parameter :: Parse (string const& mopipline)
{
  bool isparsed = false;

  // make a copy of the line
  char* linecopy = new char [mopipline.length () + 1];
  (void) strcpy (linecopy, mopipline.c_str ());

  // skip over the value type
  char* token = strtok (linecopy, " ");

  // set the enumerator, based on the sensor name
  string name = strtok (NULL, " ");
  if      (name == "PMC1") enumerator = PMCPhaseError1;
  else if (name == "PMC2") enumerator = PMCPhaseError2;
  else ReportNameError ("PMCPhaseError", name);

  // read in the values
  int valuecount = 0;
  while ((token = strtok (NULL, " =,[]\n")) != NULL && valuecount < PARAMETER_COUNT) {
    switch (valuecount) {
      case 0 : gain = atof (token);
               break;
      case 1 : offset = atof (token);
               break;
      case 2 : low = (float) atof (token);
               break;
      case 3 : high = (float) atof (token);
               break;
      default : break;
    }

    valuecount++;
  }

  delete [] linecopy;

  if (valuecount == PARAMETER_COUNT)
    isparsed = true;
  else
    ReportValuesError ("PMCPhaseError", name);

  return isparsed;
}
