/********** MotorCurrentParameter.C ***********************************************************************************\

 $Header$

 REVISION HISTORY
   03/99   Charles Cavanaugh
   10/99   Charles Cavanaugh
   05/00   Charles Cavanaugh

 $Log$

\**********************************************************************************************************************/

#include <string.h>
#include <stdlib.h>
#include "MotorCurrentParameter.h"

int const motor_current_parameter::PARAMETER_COUNT = 4;

motor_current_parameter :: motor_current_parameter ()
                         : mopip_parameter ()
{
  gain = 0.0;
  offset = 0.0;
  low = 0;
  high = 0;
}


motor_current_parameter :: ~motor_current_parameter ()
{
  ;
}


void motor_current_parameter :: Compute (float sensor [COMPUTE_TERMS], float average [COMPUTE_TERMS]) const
{
  // convert the sensor to amps
  average [COMPUTE_TERM_AVERAGE] = offset + (gain * sensor [COMPUTE_TERM_AVERAGE]);
  average [COMPUTE_TERM_VARIANCE] = gain * gain * sensor [COMPUTE_TERM_VARIANCE];
}


void motor_current_parameter :: GetRange (float& highrange, float& lowrange) const
{
  highrange = high;
  lowrange = low;
}


bool motor_current_parameter :: Parse (string const& mopipline)
{
  bool isparsed = false;

  // make a copy of the line
  char* linecopy = new char [mopipline.length () + 1];
  (void) strcpy (linecopy, mopipline.c_str ());

  // skip over the value type
  char* token = strtok (linecopy, " ");

  // set the enumerator, based on the sensor name
  string name = strtok (NULL, " ");
  if      (name == "LMC1")     enumerator = LMCMotorCurrent1;
  else if (name == "LMC2")     enumerator = LMCMotorCurrent2;
  else if (name == "LMC3")     enumerator = LMCMotorCurrent3;
  else if (name == "LMC4")     enumerator = LMCMotorCurrent4;
  else if (name == "PMC1")     enumerator = PMCMotorCurrent1;
  else if (name == "PMC2")     enumerator = PMCMotorCurrent2;
  else if (name == "Chopper1") enumerator = ChopperMotorCurrent1;
  else if (name == "Chopper2") enumerator = ChopperMotorCurrent2;
  else if (name == "Chopper3") enumerator = ChopperMotorCurrent3;
  else if (name == "Chopper4") enumerator = ChopperMotorCurrent4;
  else if (name == "Mirror1")  enumerator = MirrorMotorCurrent1;
  else if (name == "Mirror2")  enumerator = MirrorMotorCurrent2;
  else if (name == "Mirror3")  enumerator = MirrorMotorCurrent3;
  else if (name == "Mirror4")  enumerator = MirrorMotorCurrent4;
  else ReportNameError ("MotorCurrent", name);

  // read in the values
  int valuecount = 0;
  while ((token = strtok (NULL, " =,[]\n")) != NULL && valuecount < PARAMETER_COUNT) {
    switch (valuecount) {
      case 0 : gain = atof (token);
               break;
      case 1 : offset = atof (token);
               break;
      case 2 : low = (float) atof (token);
               break;
      case 3 : high = (float) atof (token);
               break;
      default : break;
    }

    valuecount++;
  }

  delete [] linecopy;

  if (valuecount == PARAMETER_COUNT)
    isparsed = true;
  else
    ReportValuesError ("MotorCurrent", name);

  return isparsed;
}
