/********** MOPIPValues.h *********************************************************************************************\

 $Header$

 REVISION HISTORY
   12/98   Charles Cavanaugh
   10/99   Charles Cavanaugh

 $Log$

\**********************************************************************************************************************/

#if !defined _MOPITT_L1_MOPIP_VALUES_

  #define _MOPITT_L1_MOPIP_VALUES_

  #include "MOPIPParameter.h"
  #include "ParameterEnumerators.h"

  int const PIXELS        = 4;
  int const VECTOR_LENGTH = 3;

  class mopip_values {
    private :
      static int const PIXEL_ERROR;
      static int const TYPE_ERROR;
      static int const RETRIEVE_ERROR;
      static int const STARES = 29;

      mopip_parameter* parameters [MOPIP_PARAMETER_COUNT];
      double pixeluvs [STARES][PIXELS][VECTOR_LENGTH];

      bool AddPixelUV          (string const&);
      void ReportRetrieveError (enum mopip_parameter_enumerator) const;

    protected :

    public :
      mopip_values ();
      ~mopip_values ();

      bool  AddEntry (string const&);
      bool  Compute  (enum mopip_parameter_enumerator, float [COMPUTE_TERMS], float [COMPUTE_TERMS], 
                      float [COMPUTE_TERMS], float [COMPUTE_TERMS]) const;
      bool  Compute  (enum mopip_parameter_enumerator, float [COMPUTE_TERMS], float [COMPUTE_TERMS]) const;
      short GetBank  (enum mopip_parameter_enumerator) const;
      bool  GetRange (enum mopip_parameter_enumerator, float&, float&) const;
      void  GetUVs   (int, double [PIXELS][VECTOR_LENGTH]) const;
      void  GetUVs   (int, int, double [VECTOR_LENGTH]) const;
  };

#endif
