/********** MOPIPParameter.h ******************************************************************************************\

 $Header$

 REVISION HISTORY
   03/98   Charles Cavanaugh
   10/99   Charles Cavanaugh

 $Log$

\**********************************************************************************************************************/

#if !defined _MOPITT_L1_MOPIP_PARAMETER_

  #define _MOPITT_L1_MOPIP_PARAMETER_

  #include <string>
  #include "ParameterEnumerators.h"

  using namespace std;

  int const COMPUTE_TERMS = 2;

  class mopip_parameter {
    private :
      static int const NAME_ERROR;
      static int const VALUES_ERROR;

    protected :
      enum computeoffsets {COMPUTE_TERM_AVERAGE, COMPUTE_TERM_VARIANCE};

      enum mopip_parameter_enumerator enumerator;

      void BitConvert        (short, float, float, float, float&, float&, float&) const;
      void ReportNameError   (string const&, string const&) const;
      void ReportValuesError (string const&, string const&) const;

    public :
      mopip_parameter ();
      mopip_parameter (enum mopip_parameter_enumerator);
      virtual ~mopip_parameter () = 0;

      virtual void                    Compute  (float [COMPUTE_TERMS], float [COMPUTE_TERMS]) const {;}
      virtual void                    Compute  (float [COMPUTE_TERMS], float [COMPUTE_TERMS], float [COMPUTE_TERMS], 
                                                float [COMPUTE_TERMS]) const {;}
      virtual short                   GetBank  () const {return 1;}
      enum mopip_parameter_enumerator GetID    () const {return enumerator;}
      virtual void                    GetRange (float&, float&) const {;}
      virtual bool                    Parse    (string const&) {return false;}
  };

#endif
