/********** MOPIPParameter.C ******************************************************************************************\

 $Header$

 REVISION HISTORY
   03/98   Charles Cavanaugh
   10/99   Charles Cavanaugh

 $Log$

\**********************************************************************************************************************/

#include <math.h>
#include "MOPIPParameter.h"
#include "DiagnosticReporter.h"

int const mopip_parameter::NAME_ERROR   = 901;
int const mopip_parameter::VALUES_ERROR = 902;

extern diagnostic_reporter diagnosticreporter;

mopip_parameter :: mopip_parameter ()
{
  ;
}


mopip_parameter :: mopip_parameter (enum mopip_parameter_enumerator mopipenum)
{
  enumerator = mopipenum;
}


mopip_parameter :: ~mopip_parameter ()
{
  ;
}


void mopip_parameter :: BitConvert (short bits, float sensor, float hiref, float loref, float& newsensor, 
                                    float& newhiref, float& newloref) const
{
  // copy the values
  newsensor = sensor;
  newhiref = hiref;
  newloref = loref;

  // if necessary, convert the values
  if (bits > 0) {
    float mask = (float) pow (2.0, (double) bits);
    float limit = (mask / 2.0) - 1.0;
    if (newsensor > limit) newsensor -= mask;
    if (newhiref  > limit) newhiref  -= mask;
    if (newloref  > limit) newloref  -= mask;
  }
}


void mopip_parameter :: ReportNameError (string const& parametername, string const& sensorname) const
{
  string message = "Do not recognize ";
  message += parametername;
  message += " sensor ";
  message += sensorname;
  diagnosticreporter.AddEntry (DIAGNOSTICS_ERROR, DIAGNOSTICS_MOPIP_MODULE, NAME_ERROR, 0, 0, 0, 0, 0, 0, 0, 0, 
                               message);
}


void mopip_parameter :: ReportValuesError (string const& parametername, string const& sensorname) const
{
  string message = "Incorrect number of values for ";
  message += parametername;
  message += " sensor ";
  message += sensorname;
  diagnosticreporter.AddEntry (DIAGNOSTICS_ERROR, DIAGNOSTICS_MOPIP_MODULE, VALUES_ERROR, 0, 0, 0, 0, 0, 0, 0, 0, 
                               message);
}
