/********** MOPIPFile.C ***********************************************************************************************\

 $Header$

 REVISION HISTORY
   12/98   Charles Cavanaugh
   10/99   Charles Cavanaugh

 $Log$

\**********************************************************************************************************************/

#include "MOPIPFile.h"

int const mopip_file::MOPIP_FILE_MAXLINESIZE = 600;

mopip_file :: mopip_file ()
            : ascii_read_file (MOPIP_FILE_LOGICAL, MOPIP_FILE_MAXLINESIZE),
              values ()
{
  Open ();
}


mopip_file :: ~mopip_file ()
{
  Close ();
}


bool mopip_file :: Compute (enum mopip_parameter_enumerator mopipenum, float sensor [COMPUTE_TERMS], 
                            float average [COMPUTE_TERMS]) const
{
  return values.Compute (mopipenum, sensor, average);
}


bool mopip_file :: Compute (enum mopip_parameter_enumerator mopipenum, float sensor [COMPUTE_TERMS], 
                            float highref [COMPUTE_TERMS], float lowref [COMPUTE_TERMS], 
                            float average [COMPUTE_TERMS]) const
{
  return values.Compute (mopipenum, sensor, highref, lowref, average);
}


short mopip_file :: GetBank (enum mopip_parameter_enumerator mopipenum) const
{
  return values.GetBank (mopipenum);
}


bool mopip_file :: GetRange (enum mopip_parameter_enumerator mopipenum, float& high, float& low) const
{
  return values.GetRange (mopipenum, high, low);
}


void mopip_file :: GetUVs (int stare, double uvs [PIXELS][VECTOR_LENGTH]) const
{
  values.GetUVs (stare, uvs);
}


void mopip_file :: GetUVs (int stare, int pixel, double uvs [VECTOR_LENGTH]) const
{
  values.GetUVs (stare, pixel, uvs);
}


bool mopip_file :: Read ()
{
  bool isread = true;

  // while there are lines in the file, if the line is not a comment line, parse it and add the data
  string ioentry;

  while (isread && ascii_read_file::Read (ioentry)) 
    if (ioentry [0] != '#')
      if (! values.AddEntry (ioentry)) 
        isread = false;
  
  return isread;
}
