/********** HeaterVoltageParameter.C **********************************************************************************\

 $Header$

 REVISION HISTORY
   03/99   Charles Cavanaugh
   10/99   Charles Cavanaugh
   05/00   Charles Cavanaugh

 $Log$

\**********************************************************************************************************************/

#include <string.h>
#include <stdlib.h>
#include "HeaterVoltageParameter.h"

int const heater_voltage_parameter::PARAMETER_COUNT = 4;

heater_voltage_parameter :: heater_voltage_parameter ()
                          : mopip_parameter ()
{
  gain = 0.0;
  offset = 0.0;
  low = 0;
  high = 0;
}


heater_voltage_parameter :: ~heater_voltage_parameter ()
{
  ;
}


void heater_voltage_parameter :: Compute (float sensor [COMPUTE_TERMS], float average [COMPUTE_TERMS]) const
{
  // convert the sensor to voltage
  average [COMPUTE_TERM_AVERAGE] = offset + (gain * sensor [COMPUTE_TERM_AVERAGE]);
  average [COMPUTE_TERM_VARIANCE] = gain * gain * sensor [COMPUTE_TERM_VARIANCE];
}


void heater_voltage_parameter :: GetRange (float& highrange, float& lowrange) const
{
  highrange = high;
  lowrange = low;
}


bool heater_voltage_parameter :: Parse (string const& mopipline)
{
  bool isparsed = false;

  // make a copy of the line
  char* linecopy = new char [mopipline.length () + 1];
  (void) strcpy (linecopy, mopipline.c_str ());

  // skip over the value type
  char* token = strtok (linecopy, " ");

  // set the enumerator, based on the sensor name
  string name = strtok (NULL, " ");
  if      (name == "BB1")    enumerator = BlackbodyHeaterVoltage1;
  else if (name == "BB2")    enumerator = BlackbodyHeaterVoltage2;
  else if (name == "BB3")    enumerator = BlackbodyHeaterVoltage3;
  else if (name == "BB4")    enumerator = BlackbodyHeaterVoltage4;
  else if (name == "Sieve1") enumerator = SieveHeaterVoltage1;
  else if (name == "Sieve2") enumerator = SieveHeaterVoltage2;
  else if (name == "Sieve3") enumerator = SieveHeaterVoltage3;
  else if (name == "Sieve4") enumerator = SieveHeaterVoltage4;
  else ReportNameError ("HeaterVoltage", name);

  // read in the values
  int valuecount = 0;
  while ((token = strtok (NULL, " =,[]\n")) != NULL && valuecount < PARAMETER_COUNT) {
    switch (valuecount) {
      case 0 : gain = atof (token);
               break;
      case 1 : offset = atof (token);
               break;
      case 2 : low = (float) atof (token);
               break;
      case 3 : high = (float) atof (token);
               break;
      default : break;
    }

    valuecount++;
  }

  delete [] linecopy;

  if (valuecount == PARAMETER_COUNT)
    isparsed = true;
  else
    ReportValuesError ("HeaterVoltage", name);
  
  return isparsed;
}
