/********** DiodeDetectorNestParameter.C ******************************************************************************\

 $Header$

 REVISION HISTORY
   03/99   Charles Cavanaugh
   10/99   Charles Cavanaugh
   05/00   Charles Cavanaugh

 $Log$

\**********************************************************************************************************************/

#include <math.h>
#include <string.h>
#include <stdlib.h>
#include "DiodeDetectorNestParameter.h"

int const diode_detectornest_parameter::PARAMETER_COUNT = 6 + COEFFS;

diode_detectornest_parameter :: diode_detectornest_parameter ()
                              : mopip_parameter ()
{
  scale = 0.0;
  offset = 0.0;
  zU = 0.0;
  zL = 0.0;
  low = 0;
  high = 0;
  for (int i = 0; i < COEFFS; i++)
    c[i] = 0.0;
}


diode_detectornest_parameter :: ~diode_detectornest_parameter ()
{
  ;
}


void diode_detectornest_parameter :: Compute (float sensor [COMPUTE_TERMS], float average [COMPUTE_TERMS]) const
{
  // convert readings to voltage and generate the variance of the voltage
  double vD = offset + (scale * ((float) sensor [COMPUTE_TERM_AVERAGE] - 2048.5));
  double vDvariance = scale * scale * sensor [COMPUTE_TERM_VARIANCE];

  // get an intermediate value for use in the sum equation and generate the variance of the value
  double vu = ((2 * vD) - zL - zU) / (zU - zL);
  double vuvariance = 2.0 / (zU - zL);
  double v1 = acos (vu);
  double v1variance = pow (vuvariance, 2.0) / (1.0 - (vu * vu));

  // convert to degrees Kelvin and generate the variance
  double sum = 0.0;
  double variance = 0.0;
  for (int i = 0; i < COEFFS; i++) {
    sum += (c[i] * cos ((i * v1)));
    variance += (-1.0 * i * c[i] * sin ((i * v1)));
  }

  average [COMPUTE_TERM_AVERAGE] = (float) sum;
  average [COMPUTE_TERM_VARIANCE] = pow (variance, 2.0) * v1variance * vDvariance;
}


void diode_detectornest_parameter :: GetRange (float& highrange, float& lowrange) const
{
  highrange = high;
  lowrange = low;
}


bool diode_detectornest_parameter :: Parse (string const& mopipline)
{
  bool isparsed = false;

  // make a copy of the line
  char* linecopy = new char [mopipline.length () + 1];
  (void) strcpy (linecopy, mopipline.c_str ());

  // skip over the value type
  char* token = strtok (linecopy, " ");

  // set the enumerator, based on the sensor name
  string name = strtok (NULL, " ");
  if      (name == "ColdTipWide1")   enumerator = ColdTipWideTemperature1;
  else if (name == "ColdTipNarrow1") enumerator = ColdTipNarrowTemperature1;
  else if (name == "ColdTipWide2")   enumerator = ColdTipWideTemperature2;
  else if (name == "ColdTipNarrow2") enumerator = ColdTipNarrowTemperature2;
  else ReportNameError ("DiodeDetectorNest", name);

  // read in the values
  int valuecount = 0;
  int coefcount = 0;
  while ((token = strtok (NULL, " =,[]\n")) != NULL && valuecount < PARAMETER_COUNT) {
    switch (valuecount) {
      case 0 : scale = atof (token);
               break;
      case 1 : offset = atof (token);
               break;
      case 2 : zU = atof (token);
               break;
      case 3 : zL = atof (token);
               break;
      case 4 : low = (float) atof (token);
               break;
      case 5 : high = (float) atof (token);
               break;
      default : c[coefcount] = atof (token);
                coefcount++;
                break;
    }

    valuecount++;
  }

  delete [] linecopy;

  if (valuecount == PARAMETER_COUNT)
    isparsed = true;
  else
    ReportValuesError ("DiodeDetectorNest", name);

  return isparsed;
}
