/********** DiodeColdFilterParameter.h ********************************************************************************\

 $Header$

 REVISION HISTORY
   03/99   Charles Cavanaugh
   10/99   Charles Cavanaugh

 $Log$

\**********************************************************************************************************************/

#if !defined _MOPITT_L1_DIODE_COLDFILTER_PARAMETER_

  #define _MOPITT_L1_DIODE_COLDFILTER_PARAMETER_

  #include "MOPIPParameter.h"

  class diode_coldfilter_parameter : public mopip_parameter {
    private :
      static int const PARAMETER_COUNT;
      static int const COEFFS = 14;

      short  bank;
      short  bits;
      double vH;
      double vL;
      double zU;
      double zL;
      float  low;
      float  high;
      double c [COEFFS];

    protected :

    public :
      diode_coldfilter_parameter ();
      ~diode_coldfilter_parameter ();

      void  Compute  (float [COMPUTE_TERMS], float [COMPUTE_TERMS], float [COMPUTE_TERMS], float [COMPUTE_TERMS]) const;
      short GetBank  () const {return bank;}
      void  GetRange (float&, float&) const;
      bool  Parse    (string const&);
  };

#endif
