/********** CDEReadoutParameter.C *************************************************************************************\

 $Header$

 REVISION HISTORY
   03/99   Charles Cavanaugh
   10/99   Charles Cavanaugh
   05/00   Charles Cavanaugh

 $Log$

\**********************************************************************************************************************/

#include "CDEReadoutParameter.h"
#include <string.h>
#include <stdlib.h>

int const cde_readout_parameter::PARAMETER_COUNT = 4;

cde_readout_parameter :: cde_readout_parameter ()
                       : mopip_parameter ()
{
  scale = 0.0;
  offset = 0.0;
  low = 0;
  high = 0;
}


cde_readout_parameter :: ~cde_readout_parameter ()
{
  ;
}


void cde_readout_parameter :: Compute (float sensor [COMPUTE_TERMS], float average [COMPUTE_TERMS]) const
{
  // convert the sensor to engineering units
  average [COMPUTE_TERM_AVERAGE] = offset + (scale * sensor [COMPUTE_TERM_AVERAGE]);
  average [COMPUTE_TERM_VARIANCE] = scale * scale * sensor [COMPUTE_TERM_VARIANCE];
}


void cde_readout_parameter :: GetRange (float& highrange, float& lowrange) const
{
  highrange = high;
  lowrange = low;
}


bool cde_readout_parameter :: Parse (string const& mopipline)
{
  bool isparsed = false;

  // make a copy of the line
  char* linecopy = new char [mopipline.length () + 1];
  (void) strcpy (linecopy, mopipline.c_str ());

  // skip over the value type
  char* token = strtok (linecopy, " ");

  // set the enumerator, based on the sensor name
  string name = strtok (NULL, " ");
  if      (name == "CompressorC1") enumerator = CompressorCurrent1;
  else if (name == "CompressorC2") enumerator = CompressorCurrent2;
  else if (name == "CompressorP1") enumerator = CompressorPosition1;
  else if (name == "CompressorP2") enumerator = CompressorPosition2;
  else if (name == "CompressorVX") enumerator = CompressorVibrationX;
  else if (name == "CompressorVY") enumerator = CompressorVibrationY;
  else if (name == "CompressorVZ") enumerator = CompressorVibrationZ;
  else if (name == "DisplacerT1")  enumerator = DisplacerTemperature1;
  else if (name == "DisplacerT2")  enumerator = DisplacerTemperature2;
  else if (name == "DisplacerC1")  enumerator = DisplacerCurrent1;
  else if (name == "DisplacerC2")  enumerator = DisplacerCurrent2;
  else if (name == "DisplacerP1")  enumerator = DisplacerPosition1;
  else if (name == "DisplacerP2")  enumerator = DisplacerPosition2;
  else if (name == "DisplacerVX")  enumerator = DisplacerVibrationX;
  else if (name == "DisplacerVY")  enumerator = DisplacerVibrationY;
  else if (name == "DisplacerVZ")  enumerator = DisplacerVibrationZ;
  else if (name == "CDE1")         enumerator = CDETemperature1;
  else if (name == "CDE2")         enumerator = CDETemperature2;
  else if (name == "CDE3")         enumerator = CDETemperature3;
  else ReportNameError ("CDEReadout", name);

  // read in the values
  int valuecount = 0;
  while ((token = strtok (NULL, " =,[]\n")) != NULL && valuecount < PARAMETER_COUNT) {
    switch (valuecount) {
      case 0 : scale = atof (token);
               break;
      case 1 : offset = atof (token);
               break;
      case 2 : low = (float) atof (token);
               break;
      case 3 : high = (float) atof (token);
               break;
      default : break;
    }

    valuecount++;
  }

  delete [] linecopy;

  if (valuecount == PARAMETER_COUNT)
    isparsed = true;
  else
    ReportValuesError ("CDEReadout", name);
  

  return isparsed;
}
