/********** SensorSummary.h *******************************************************************************************\

 $Header$

 REVISION HISTORY
   06/99   Tom Lauren
   12/99   Charles Cavanaugh

 $Log$

\**********************************************************************************************************************/

#if !defined _MOPITT_L1_SENSOR_SUMMARY_

  #define _MOPITT_L1_SENSOR_SUMMARY_

  #include "SensorConstants.h"
  #include "EngineeringCollection.h"

  class sensor_summary {
    private :
      string                     name;
      float                      highval;
      float                      lowval;
      double                     average;
      double                     standev;
      float                      highlimit;
      float                      lowlimit;
      short                      highredcounts;
      short                      lowredcounts;
      short                      highyellowcounts;
      short                      lowyellowcounts;
      enum sensor_hardware_index hardwareindex;

      void SetInvalidateFlags (bool [SUMMARY_CHANNELS]);

    protected :

    public :
      sensor_summary ();
      ~sensor_summary ();

      void   Finalize        (long);
      string GetLimitsString () const;
      string GetValuesString () const;
      void   SetInfo         (string const&, enum sensor_hardware_index, float, float);
      void   Update          (float const [ENGINEERING_STATES], bool [SUMMARY_CHANNELS], int);
  };

#endif
