/********** SensorSummary.C *******************************************************************************************\

 $Header$

 REVISION HISTORY
   06/99   Tom Lauren
   12/99   Charles Cavanaugh

 $Log$

\**********************************************************************************************************************/

#include <math.h>
#include <values.h>
#include "SensorSummary.h"

sensor_summary :: sensor_summary ()
                : name ()
{
  highval = -MAXFLOAT;
  lowval = MAXFLOAT;
  average = 0.0;
  standev = 0.0;
  highlimit = 0.0;
  lowlimit = 0.0;
  highredcounts = 0;
  lowredcounts = 0;
  highyellowcounts = 0;
  lowyellowcounts = 0;
  hardwareindex = INSTRUMENT_SENSOR;
}


sensor_summary :: ~sensor_summary ()
{
  ;
}


void sensor_summary :: SetInvalidateFlags (bool invalidators [SUMMARY_CHANNELS])
{
  switch (hardwareindex) {
    case CHANNEL1_SENSOR   : invalidators [0] = true; 
                             break;
    case CHANNEL2_SENSOR   : invalidators [1] = true; 
                             break;
    case CHANNEL3_SENSOR   : invalidators [2] = true; 
                             break;
    case CHANNEL4_SENSOR   : invalidators [3] = true; 
                             break;
    case CHANNEL5_SENSOR   : invalidators [4] = true; 
                             break;
    case CHANNEL6_SENSOR   : invalidators [5] = true; 
                             break;
    case CHANNEL7_SENSOR   : invalidators [6] = true; 
                             break;
    case CHANNEL8_SENSOR   : invalidators [7] = true; 
                             break;
    case TRAIN1_SENSOR     : invalidators [0] = true;
                             invalidators [1] = true; 
                             break;
    case TRAIN2_SENSOR     : invalidators [2] = true;
                             invalidators [3] = true; 
                             break;
    case TRAIN3_SENSOR     : invalidators [4] = true;
                             invalidators [5] = true; 
                             break;
    case TRAIN4_SENSOR     : invalidators [6] = true;
                             invalidators [7] = true; 
                             break;
    case BENCH1_SENSOR     : invalidators [0] = true;
                             invalidators [1] = true;
                             invalidators [2] = true;
                             invalidators [3] = true; 
                             break;
    case BENCH2_SENSOR     : invalidators [4] = true;
                             invalidators [5] = true;
                             invalidators [6] = true;
                             invalidators [7] = true; 
                             break;
    case INSTRUMENT_SENSOR : invalidators [0] = true;
                             invalidators [1] = true;
                             invalidators [2] = true;
                             invalidators [3] = true;
                             invalidators [4] = true;
                             invalidators [5] = true;
                             invalidators [6] = true;
                             invalidators [7] = true; 
                             break;
  }
}


void sensor_summary :: Finalize (long trackcount)
{
  if (trackcount == 0) {
    highval = SUMMARY_MISSING_VALUE;
    lowval = SUMMARY_MISSING_VALUE;
  }
  else {
    average /= (double) trackcount;
    standev /= (double) trackcount;
  }
}


string sensor_summary :: GetLimitsString () const
{
  char str [200];
  (void) sprintf (str, "%-33s %-11f %-10hi %-13hi %-12f %-11hi %-14hi", name.c_str (), lowlimit, 
                  lowredcounts, lowyellowcounts, highlimit, highredcounts, highyellowcounts);
  string limitsstring = str;
  return limitsstring;
}


string sensor_summary :: GetValuesString () const
{
  char str [200];
  (void) sprintf (str, "%-33s %-14e %-14e %-16e %-21e", name.c_str (), lowval, highval, (float) average, 
                  (float) standev);
  string valuesstring = str;
  return valuesstring;
}


void sensor_summary :: SetInfo (string const& sensorname, enum sensor_hardware_index sensorhardwareindex, 
                                float sensorhighlimit, float sensorlowlimit)
{
  name = sensorname;
  hardwareindex = sensorhardwareindex;
  highlimit = sensorhighlimit;
  lowlimit = sensorlowlimit;
}


void sensor_summary :: Update (float const engvalues [SUMMARY_ENGINEERING_STATES], bool invalidate [SUMMARY_CHANNELS], int ind)
{
  // proceed only if the average value is not missing
  float thisaverage = engvalues [ENGINEERING_AVERAGE_VALUE];
  if (((int) (thisaverage + 0.5)) != ((int) (SUMMARY_MISSING_VALUE + 0.5))) {

    float thisstandev = sqrt (engvalues [ENGINEERING_VARIANCE_VALUE]);

    if (thisaverage < lowval)
      lowval = thisaverage;

    if (thisaverage > highval)
      highval = thisaverage;

    if (thisaverage < lowlimit) {
      if ( sensornamestring[ind] != "PMC 1 Phase Error" && sensornamestring[ind] != "Compressor 2 Position" ) {
	lowredcounts++;
	SetInvalidateFlags (invalidate);
      }
    } 
    else if (thisaverage > highlimit) {
      if ( sensornamestring[ind] != "PMC 1 Phase Error" && sensornamestring[ind] != "Compressor 2 Position" ) {
	highredcounts++;
	SetInvalidateFlags (invalidate);
      }
    } 
    else if ((thisaverage - thisstandev) < lowlimit)
      if ( sensornamestring[ind] != "PMC 1 Phase Error" && sensornamestring[ind] != "Compressor 2 Position" )      
	lowyellowcounts++;
    else if ((thisaverage + thisstandev) > highlimit)
      if ( sensornamestring[ind] != "PMC 1 Phase Error" && sensornamestring[ind] != "Compressor 2 Position" )
	highyellowcounts++;

    average += (double) thisaverage;
    standev += (double) thisstandev;
  }
}
