/********** SensorConstants.h *****************************************************************************************\

 $Header$

 REVISION HISTORY
   06/99   Tom Lauren
   12/99   Charles Cavanaugh
   02/00   Tom Lauren

 $Log$

\**********************************************************************************************************************/

#if !defined _MOPITT_L1_SENSOR_NAME_INFO_

  #define _MOPITT_L1_SENSOR_NAME_INFO_

  #include <string>
  #include "EngineeringDataConstants.h"
  #include "ScienceConstants.h"

  using namespace std;
  
  int const SUMMARY_CHANNELS           = SCIENCE_CHANNELS;
  int const SUMMARY_ENGINEERING_STATES = ENGINEERING_STATES;
  int const SUMMARY_ENGINEERING_VALUES = ENGINEERING_SUMMARY_VALUES;
  int const SUMMARY_MISSING_VALUE      = ENGINEERING_MISSING_VALUE;

  enum sensor_hardware_index { CHANNEL1_SENSOR,  CHANNEL2_SENSOR,  CHANNEL3_SENSOR,  CHANNEL4_SENSOR,
                               CHANNEL5_SENSOR,  CHANNEL6_SENSOR,  CHANNEL7_SENSOR,  CHANNEL8_SENSOR,
                               TRAIN1_SENSOR,    TRAIN2_SENSOR,    TRAIN3_SENSOR,    TRAIN4_SENSOR, 
                               BENCH1_SENSOR,    BENCH2_SENSOR,    INSTRUMENT_SENSOR };

  string const sensornamestring [SUMMARY_ENGINEERING_VALUES] = {
           "Blackbody 1 Temperature 1",        "Blackbody 1 Temperature 2", 
           "Blackbody 2 Temperature 1",        "Blackbody 2 Temperature 2", 
           "Blackbody 3 Temperature 1",        "Blackbody 3 Temperature 2", 
           "Blackbody 4 Temperature 1",        "Blackbody 4 Temperature 2", 
           "Blackbody 1 Heater Voltage",       "Blackbody 2 Heater Voltage", 
           "Blackbody 3 Heater Voltage",       "Blackbody 4 Heater Voltage", 
           "Chopper 1 Temperature",            "Chopper 2 Temperature", 
           "Chopper 3 Temperature",            "Chopper 4 Temperature", 
           "Chopper 1 Motor Current",          "Chopper 2 Motor Current", 
           "Chopper 3 Motor Current",          "Chopper 4 Motor Current", 
           "Cold Filter 1 Temperature",        "Cold Filter 3 Temperature", 
           "Cold Filter 5 Temperature",        "Cold Filter 7 Temperature", 
           "Cold Tip 1 Narrow Temperature",    "Cold Tip 1 Wide Temperature", 
           "Cold Tip 2 Narrow Temperature",    "Cold Tip 2 Wide Temperature", 
           "Detector 1 Temperature",           "Detector 2 Temperature", 
           "Detector 3 Temperature",           "Detector 4 Temperature", 
           "Detector 5 Temperature",           "Detector 6 Temperature", 
           "Detector 7 Temperature",           "Detector 8 Temperature", 
           "LMC 1 Temperature",                "LMC 2 Temperature", 
           "LMC 3 Temperature",                "LMC 4 Temperature", 
           "LMC 1 Pressure Temperature",       "LMC 2 Pressure Temperature", 
           "LMC 3 Pressure Temperature",       "LMC 4 Pressure Temperature", 
           "LMC 1 Pressure",                   "LMC 2 Pressure", 
           "LMC 3 Pressure",                   "LMC 4 Pressure", 
           "LMC 1 Motor Current",              "LMC 2 Motor Current", 
           "LMC 3 Motor Current",              "LMC 4 Motor Current", 
           "Mirror 1 Motor Temperature",       "Mirror 2 Motor Temperature", 
           "Mirror 3 Motor Temperature",       "Mirror 4 Motor Temperature", 
           "Mirror 1 Motor Current",           "Mirror 2 Motor Current", 
           "Mirror 3 Motor Current",           "Mirror 4 Motor Current", 
           "PMC 1 Temperature",                "PMC 2 Temperature", 
           "PMC 1 Amplitude",                  "PMC 2 Amplitude", 
           "PMC 1 Phase Error",                "PMC 2 Phase Error", 
           "PMC 1 Motor Current",              "PMC 2 Motor Current", 
           "Sieve 1 Temperature",              "Sieve 2 Temperature", 
           "Sieve 3 Temperature",              "Sieve 4 Temperature", 
           "Sieve 1 Heater Voltage",           "Sieve 2 Heater Voltage", 
           "Sieve 3 Heater Voltage",           "Sieve 4 Heater Voltage", 
           "SPM 1 Temperature",                "SPM 2 Temperature", 
           "Table 1 Temperature 1",            "Table 1 Temperature 2", 
           "Table 1 Temperature 3",            "Table 1 Temperature 4", 
           "Table 2 Temperature 1",            "Table 2 Temperature 2", 
           "Table 2 Temperature 3",            "Table 2 Temperature 4", 
           "TCMM A Temperature 1",             "TCMM A Temperature 2", 
           "TCMM B Temperature 1",             "TCMM B Temperature 2", 
           "Earth Port Baffel Temperature",    "Space Port Baffel Temperature", 
           "Baseplate 1 Temperature",          "Baseplate 2 Temperature", 
           "Baseplate 3 Temperature",          "PSM Temperature", 
           "Compressor 1 Current",             "Compressor 2 Current", 
           "Compressor 1 Position",            "Compressor 2 Position", 
           "Compressor 1 Temperature",         "Compressor 2 Temperature", 
           "Displacer 1 Current",              "Displacer 2 Current", 
           "Displacer 1 Position",             "Displacer 2 Position", 
           "Displacer 1 Temperature",          "Displacer 2 Temperature", 
           "Compressor X Vibration",           "Displacer X Vibration", 
           "Compressor Y Vibration",           "Displacer Y Vibration", 
           "Compressor Z Vibration",           "Displacer Z Vibration", 
           "CDE 1 Temperature",                "CDE 2 Temperature", 
           "CDE 3 Temperature" };

  enum sensor_hardware_index const sensorhardwareindex [SUMMARY_ENGINEERING_VALUES] = {
           TRAIN1_SENSOR,      TRAIN1_SENSOR,      TRAIN2_SENSOR,      TRAIN2_SENSOR,
           TRAIN3_SENSOR,      TRAIN3_SENSOR,      TRAIN4_SENSOR,      TRAIN4_SENSOR,
           TRAIN1_SENSOR,      TRAIN2_SENSOR,      TRAIN3_SENSOR,      TRAIN4_SENSOR,
           TRAIN1_SENSOR,      TRAIN2_SENSOR,      TRAIN3_SENSOR,      TRAIN4_SENSOR,
           TRAIN1_SENSOR,      TRAIN2_SENSOR,      TRAIN3_SENSOR,      TRAIN4_SENSOR,
           TRAIN1_SENSOR,      TRAIN2_SENSOR,      TRAIN3_SENSOR,      TRAIN4_SENSOR,
           BENCH1_SENSOR,      BENCH1_SENSOR,      BENCH2_SENSOR,      BENCH2_SENSOR,
           CHANNEL1_SENSOR,    CHANNEL2_SENSOR,    CHANNEL3_SENSOR,    CHANNEL4_SENSOR,
           CHANNEL5_SENSOR,    CHANNEL6_SENSOR,    CHANNEL7_SENSOR,    CHANNEL8_SENSOR,
           TRAIN1_SENSOR,      CHANNEL4_SENSOR,    TRAIN3_SENSOR,      CHANNEL8_SENSOR,
           TRAIN1_SENSOR,      CHANNEL4_SENSOR,    TRAIN3_SENSOR,      CHANNEL8_SENSOR,
           TRAIN1_SENSOR,      CHANNEL4_SENSOR,    TRAIN3_SENSOR,      CHANNEL8_SENSOR,
           TRAIN1_SENSOR,      CHANNEL4_SENSOR,    TRAIN3_SENSOR,      CHANNEL8_SENSOR,
           TRAIN1_SENSOR,      TRAIN2_SENSOR,      TRAIN3_SENSOR,      TRAIN4_SENSOR,
           TRAIN1_SENSOR,      TRAIN2_SENSOR,      TRAIN3_SENSOR,      TRAIN4_SENSOR,
           CHANNEL3_SENSOR,    CHANNEL7_SENSOR,    CHANNEL3_SENSOR,    CHANNEL7_SENSOR,
           CHANNEL3_SENSOR,    CHANNEL7_SENSOR,    CHANNEL3_SENSOR,    CHANNEL7_SENSOR,
           TRAIN1_SENSOR,      CHANNEL3_SENSOR,    TRAIN3_SENSOR,      CHANNEL7_SENSOR,
           TRAIN1_SENSOR,      CHANNEL3_SENSOR,    TRAIN3_SENSOR,      CHANNEL7_SENSOR,
           BENCH1_SENSOR,      BENCH2_SENSOR,      BENCH1_SENSOR,      BENCH1_SENSOR,
           BENCH1_SENSOR,      BENCH1_SENSOR,      BENCH2_SENSOR,      BENCH2_SENSOR,
           BENCH2_SENSOR,      BENCH2_SENSOR,      INSTRUMENT_SENSOR,  INSTRUMENT_SENSOR,
           INSTRUMENT_SENSOR,  INSTRUMENT_SENSOR,  INSTRUMENT_SENSOR,  INSTRUMENT_SENSOR,
           INSTRUMENT_SENSOR,  INSTRUMENT_SENSOR,  INSTRUMENT_SENSOR,  INSTRUMENT_SENSOR,
           INSTRUMENT_SENSOR,  INSTRUMENT_SENSOR,  INSTRUMENT_SENSOR,  INSTRUMENT_SENSOR,
           INSTRUMENT_SENSOR,  INSTRUMENT_SENSOR,  INSTRUMENT_SENSOR,  INSTRUMENT_SENSOR,
           INSTRUMENT_SENSOR,  INSTRUMENT_SENSOR,  INSTRUMENT_SENSOR,  INSTRUMENT_SENSOR,
           INSTRUMENT_SENSOR,  INSTRUMENT_SENSOR,  INSTRUMENT_SENSOR,  INSTRUMENT_SENSOR,
           INSTRUMENT_SENSOR,  INSTRUMENT_SENSOR,  INSTRUMENT_SENSOR,  INSTRUMENT_SENSOR,
           INSTRUMENT_SENSOR };
  
#endif
