/********** MOPESSummary.C ********************************************************************************************\

 $Header$

 REVISION HISTORY
   06/99   Charles Cavanaugh
   06/99   Tom Lauren
   12/99   Charles Cavanaugh
   01/02   Debbie Mao

 $Log$

\**********************************************************************************************************************/

#include "MOPESSummary.h"
#include "GlobalMetadata.h"

extern global_metadata globalmetadata;

mopes_summary :: mopes_summary ()
               : starttime (),
                 stoptime ()
{
  ;
}


mopes_summary :: mopes_summary (mopip_file const& mopipfile)
               : starttime (),
                 stoptime ()
{
  trackcount = 0;
  tracksoutofbounds = 0;
  float highlimit, lowlimit;
  for (int i = 0; i < SUMMARY_ENGINEERING_VALUES; i++) {
    mopipfile.GetRange ((mopip_parameter_enumerator) i, highlimit, lowlimit);
    sensor[i].SetInfo (sensornamestring [i], sensorhardwareindex [i], highlimit, lowlimit);
  }
}


mopes_summary :: ~mopes_summary ()
{
  ;
}


bool mopes_summary :: GetLine (char* summaryline)
{
  static bool printedheader = false;
  static bool printedtracks = false;
  static bool printedstarttime = false;
  static bool printedstoptime = false;
  static bool printedvaluesheader = false;
  static bool printedvalues = false;
  static bool printedlimitsheader = false;
  static bool printedlimits = false;
  bool retrievedline = true;

  string startutc = starttime.GetUTC ();
  string stoputc = stoptime.GetUTC ();

  // write out the file header
  if (! printedheader) {
    (void) sprintf (summaryline, "%s", "QA File Eng Summary");
    printedheader = true;
  }
  else if (! printedtracks) {
    (void) sprintf (summaryline, "\nTracks :     %ld", trackcount);
    printedtracks = true;
  }
  else if (! printedstarttime) {
    (void) sprintf (summaryline, "Start Time : %s", startutc.c_str ());
    printedstarttime = true;
  }
  else if (! printedstoptime) {
    char startdate[DATE_SIZE], stopdate[DATE_SIZE];
    (void) strncpy ( startdate, startutc.c_str(), ( DATE_SIZE-1) );
    startdate[DATE_SIZE-1] = '\0';
    (void) strncpy ( stopdate, stoputc.c_str(), ( DATE_SIZE-1) );
    stopdate[DATE_SIZE-1] = '\0';
    if ( int issamedate = strcmp ( startdate, stopdate ) != 0 ) 
      (void) sprintf (summaryline, "Stop Time :  %s%s", startdate, "T23:59:59.999999Z" );
    else
      (void) sprintf (summaryline, "Stop Time :  %s", stoputc.c_str ());
    printedstoptime = true;
  }
  else if (! printedvaluesheader) {
    (void) sprintf (summaryline, "\n%-33s %-14s %-14s %-16s %-21s", "Sensor Name", "Low Value", 
                    "High Value", "Average Value", "Standard Deviation");
    printedvaluesheader = true;
  }
  else if (! printedvalues) {
    static int valuescounter = 0;
    (void) sprintf (summaryline, "%s", (sensor[valuescounter].GetValuesString()).c_str ());
    valuescounter++;
    if (valuescounter == SUMMARY_ENGINEERING_VALUES)
      printedvalues = true;
  }
  else if (! printedlimitsheader) {
    (void) sprintf (summaryline, "\n%-33s %-11s %-10s %-13s %-12s %-11s %-14s", "Sensor Name", "Low Limit", "Low Reds", 
                    "Low Yellows", "High Limit", "High Reds", "High Yellows");
    printedlimitsheader = true;
  }
  else if (! printedlimits) {
    static int limitscounter = 0;
    (void) sprintf (summaryline, "%s", (sensor[limitscounter].GetLimitsString()).c_str ());
    limitscounter++;      
    if (limitscounter == SUMMARY_ENGINEERING_VALUES) 
      printedlimits = true;
  }
  else
    retrievedline = false;


  return retrievedline;
}


void mopes_summary :: Update (mopitt_time const& timestart, mopitt_time const& timestop, mopip_file const& mopipfile, 
                              engineering_collection& engineeringcollection, bool invalidate [SUMMARY_CHANNELS])
{
  int i;

  float summarydata [SUMMARY_ENGINEERING_VALUES][ENGINEERING_STATES];
  memset ((float*) summarydata, 0, sizeof (float[SUMMARY_ENGINEERING_VALUES][ENGINEERING_STATES]));

  // Initialize the invalidate flags to false.
  for (i = 0; i < SUMMARY_CHANNELS; i++)
    invalidate [i] = false;

  engineeringcollection.GetSummaryData (timestart, timestop, mopipfile, summarydata);
  for (i = 0; i < SUMMARY_ENGINEERING_VALUES; i++) 
    sensor[i].Update (summarydata [i], invalidate, i); 
    
  if (trackcount == 0)
    starttime = timestart;
  stoptime = timestop;
    
  trackcount++;

  bool invalidatetrack = false;
  for (i = 0; i < SUMMARY_CHANNELS && ! invalidatetrack; i++)
    if (invalidate [i])
      invalidatetrack = true;

  if (invalidatetrack)
    tracksoutofbounds++;
}


void mopes_summary :: Finalize ()
{
  for (int i = 0; i < SUMMARY_ENGINEERING_VALUES; i++)
    sensor[i].Finalize (trackcount);
  globalmetadata.SetTrackCount (trackcount);
  globalmetadata.SetTracksOutofBounds (tracksoutofbounds);
  globalmetadata.SetStartTime (starttime);
  globalmetadata.SetStopTime (stoptime);
}
