/********** MOPESMetadata.C *******************************************************************************************\

 $Header$

 REVISION HISTORY
   06/99  Tom Lauren
   08/99  Charles Cavanaugh

 $Log$

\**********************************************************************************************************************/

#include "MOPESMetadata.h"
#include "GlobalMetadata.h"

extern global_metadata globalmetadata;

PGSt_PC_Logical const mopes_metadata::MOPES_MCF_FILELOGICAL = 41801;
PGSt_PC_Logical const mopes_metadata::MOPES_MET_FILELOGICAL = 41802;

mopes_metadata :: mopes_metadata ()
                : ascii_metadata ()
{
  ;
}


mopes_metadata :: mopes_metadata (PGSt_PC_Logical asciifilelogical)
                : ascii_metadata (MOPES_MCF_FILELOGICAL)
{
  Set (asciifilelogical);
}


mopes_metadata :: ~mopes_metadata ()
{
  ;
}


bool mopes_metadata :: Set (PGSt_PC_Logical asciifilelogical)
{
  bool isset = false;

  // initialize the metadata mechanism
  if (Initialize ())

    // store the metadata (extracting necessary stuff from global metadata)
    if (mopesmetadatagroups.Set (asciifilelogical, globalmetadata.GetStartTime (), globalmetadata.GetStopTime (),
                                 GetHandle ()))
      isset = true;

  return isset;
}


bool mopes_metadata :: Write ()
{
  return ascii_metadata::Write (MOPES_MET_FILELOGICAL);
}
