/********** MOPESFile.C ***********************************************************************************************\

 $Header$

 REVISION HISTORY
   06/99   Charles Cavanaugh
   06/99   Tom Lauren
   12/99   Charles Cavanaugh

 $Log$

\**********************************************************************************************************************/

#include "MOPESFile.h"
#include "MOPESMetadata.h"

PGSt_PC_Logical const mopes_file::MOPES_FILE_LOGICAL     = 41800;
int const             mopes_file::MOPES_FILE_MAXLINESIZE = 256;

mopes_file :: mopes_file ()
            : ascii_write_file (MOPES_FILE_LOGICAL),
	      summary ()
{
  ;
}

mopes_file :: mopes_file (mopip_file const& mopipfile)
            : ascii_write_file (MOPES_FILE_LOGICAL),
	      summary (mopipfile)
{
  ;
}

mopes_file :: ~mopes_file ()
{
  Finalize ();
}


bool mopes_file :: Finalize ()
{
  bool isfinalized = false;

  if (Open ()) {
    summary.Finalize ();
    if (Write ()) {
      mopes_metadata mopesmetadata (MOPES_FILE_LOGICAL);
      if (mopesmetadata.Write ())
        if (Close ())
          isfinalized = true;
    }
  }
 
  return isfinalized;
}


bool mopes_file :: Write ()
{
  bool iswritten = true;

  // while there is summary data to write, write it to the file
  char ioentry [MOPES_FILE_MAXLINESIZE];
  while (iswritten && summary.GetLine (ioentry))
    if (! ascii_write_file::Write (ioentry))
      iswritten = false;

  return iswritten;
}


void mopes_file :: Update (mopitt_time const& starttime, mopitt_time const& stoptime, mopip_file const& mopipfile, 
                           engineering_collection& engineeringcollection, bool invalidate [SUMMARY_CHANNELS])
{
  summary.Update (starttime, stoptime, mopipfile, engineeringcollection, invalidate);
}
