/********** MOPCHWriteFile.C ******************************************************************************************\

 $Header$

 REVISION HISTORY
   12/98  Charles Cavanaugh
   06/99  Tom Lauren
   08/99  Charles Cavanaugh

 $Log$

\**********************************************************************************************************************/

#include "MOPCHWriteFile.h"
#include "MOPCHMetadata.h"

PGSt_PC_Logical const mopch_write_file::MOPCH_WRITE_FILE_LOGICAL = 41500;

mopch_write_file :: mopch_write_file ()
                  : mopch_file (MOPCH_WRITE_FILE_LOGICAL)
{
  Open ();
}


mopch_write_file :: ~mopch_write_file ()
{
  Close ();
}


bool mopch_write_file :: Close ()
{
  bool isclosed = false;
  mopch_metadata mopchmetadata (MOPCH_WRITE_FILE_LOGICAL);

  if (mopchmetadata.Write (GetMetadataID()))
    if (mopch_file::Close ())
      isclosed = true;

  return isclosed;
}


bool mopch_write_file :: Open ()
{
  bool isopen = false;

  if (mopch_file::Open (MOPCH_OPEN_WRITE))
    if (tablegroup.Create ("Table Group", "MOPITT Group", fileid))
      if (engineeringgroup.Create ("Engineering Group", "MOPITT Group", fileid))
        if (sciencegroup.Create ("Science Group", "MOPITT Group", fileid))
          isopen = true;

  return isopen;
}

