/********** MOPCHMetadataGroups.C *************************************************************************************\

 $Header$

 REVISION HISTORY
   06/99  Tom Lauren
   08/99  Charles Cavanaugh

 $Log$

\**********************************************************************************************************************/

#include "MOPCHMetadataGroups.h"
#include "MOPIPFile.h"
#include "ScienceCollection.h"
#include "EngineeringCollection.h"
#include "TableCollection.h"

mopch_metadata_groups :: mopch_metadata_groups ()
{
  ;
}


mopch_metadata_groups :: ~mopch_metadata_groups ()
{
  ;
}


bool mopch_metadata_groups :: Set (PGSt_PC_Logical hdffilelogical, mopitt_time const& starttime, 
                                   mopitt_time const& stoptime, int cold1cals, int cold2cals, int cold3cals, 
                                   int cold4cals, int warm1cals, int warm2cals, int warm3cals, int warm4cals, 
                                   int hot1cals, int hot2cals, int hot3cals, int hot4cals, char eventdesc [], 
                                   PGSt_MET_handle handle)
{
  bool isset = false;

  if (inputgranule.Set (handle, 37, MOPIP_FILE_LOGICAL,
                        SCIENCE_COLLECTION_01_LOGICAL, SCIENCE_COLLECTION_02_LOGICAL, SCIENCE_COLLECTION_03_LOGICAL,
                        SCIENCE_COLLECTION_04_LOGICAL, SCIENCE_COLLECTION_05_LOGICAL, SCIENCE_COLLECTION_06_LOGICAL, 
                        SCIENCE_COLLECTION_07_LOGICAL, SCIENCE_COLLECTION_08_LOGICAL, SCIENCE_COLLECTION_09_LOGICAL,
                        SCIENCE_COLLECTION_10_LOGICAL, SCIENCE_COLLECTION_11_LOGICAL, SCIENCE_COLLECTION_12_LOGICAL,
                        ENGINEERING_COLLECTION_01_LOGICAL, ENGINEERING_COLLECTION_02_LOGICAL, 
                        ENGINEERING_COLLECTION_03_LOGICAL, ENGINEERING_COLLECTION_04_LOGICAL, 
                        ENGINEERING_COLLECTION_05_LOGICAL, ENGINEERING_COLLECTION_06_LOGICAL, 
                        ENGINEERING_COLLECTION_07_LOGICAL, ENGINEERING_COLLECTION_08_LOGICAL, 
                        ENGINEERING_COLLECTION_09_LOGICAL, ENGINEERING_COLLECTION_10_LOGICAL, 
                        ENGINEERING_COLLECTION_11_LOGICAL, ENGINEERING_COLLECTION_12_LOGICAL,
                        TABLE_COLLECTION_01_LOGICAL, TABLE_COLLECTION_02_LOGICAL, TABLE_COLLECTION_03_LOGICAL,
                        TABLE_COLLECTION_04_LOGICAL, TABLE_COLLECTION_05_LOGICAL, TABLE_COLLECTION_06_LOGICAL, 
                        TABLE_COLLECTION_07_LOGICAL, TABLE_COLLECTION_08_LOGICAL, TABLE_COLLECTION_09_LOGICAL,
                        TABLE_COLLECTION_10_LOGICAL, TABLE_COLLECTION_11_LOGICAL, TABLE_COLLECTION_12_LOGICAL))
    if (ecsdatagranule.Set (handle, hdffilelogical))
      if (pgeversionclass.Set (handle, hdffilelogical))
        if (rangedatetime.Set (handle, starttime, stoptime))
          if (mopchpsas.Set (handle, cold1cals, cold2cals, cold3cals, cold4cals, warm1cals, warm2cals, warm3cals, 
                             warm4cals, hot1cals, hot2cals, hot3cals, hot4cals, eventdesc))
            isset = true;

  return isset;
}
