/********** MOPCHMetadata.C *******************************************************************************************\

 $Header$

 REVISION HISTORY
   06/99  Tom Lauren
   08/99  Charles Cavanaugh

 $Log$

\**********************************************************************************************************************/

#include "MOPCHMetadata.h"
#include "MOPCHGlobalMetadata.h"
#include "GlobalMetadata.h"

PGSt_PC_Logical const mopch_metadata::MOPCH_MCF_FILELOGICAL = 41501;

mopch_metadata :: mopch_metadata ()
                : hdf_metadata ()
{
  ;
}


mopch_metadata :: mopch_metadata (PGSt_PC_Logical hdffilelogical)
                : hdf_metadata (MOPCH_MCF_FILELOGICAL)
{
  Set (hdffilelogical);
}


mopch_metadata :: ~mopch_metadata ()
{
  ;
}


bool mopch_metadata :: Set (PGSt_PC_Logical hdffilelogical)
{
  bool isset = false;

  // initialize the metadata mechanism
  if (Initialize ()) {

    // store the metadata (extracting necessary stuff from global metadata)
    extern global_metadata globalmetadata;
    extern mopch_global_metadata mopchglobalmetadata;
    char eventdesc [500];
    mopchglobalmetadata.GetEventDesc (eventdesc);
    if (mopchmetadatagroups.Set (hdffilelogical, globalmetadata.GetStartTime (), globalmetadata.GetStopTime (),
                                 mopchglobalmetadata.GetCold1Cals (), mopchglobalmetadata.GetCold2Cals (),
                                 mopchglobalmetadata.GetCold3Cals (), mopchglobalmetadata.GetCold4Cals (),
                                 mopchglobalmetadata.GetWarm1Cals (), mopchglobalmetadata.GetWarm2Cals (),
                                 mopchglobalmetadata.GetWarm3Cals (), mopchglobalmetadata.GetWarm4Cals (),
                                 mopchglobalmetadata.GetHot1Cals (),  mopchglobalmetadata.GetHot2Cals (),
                                 mopchglobalmetadata.GetHot3Cals (),  mopchglobalmetadata.GetHot4Cals (), eventdesc,
                                 GetHandle ()))
      isset = true;
  }

  return isset;
}


bool mopch_metadata :: Write (int32 metadataid)
{
  return hdf_metadata::Write (metadataid);
}
