/********** MOPCHFile.h ***********************************************************************************************\

 $Header$

 REVISION HISTORY
   12/98  Charles Cavanaugh

 $Log$

\**********************************************************************************************************************/

#if !defined _MOPITT_L1_MOPCH_FILE_

  #define _MOPITT_L1_MOPCH_FILE_

  #include "HDFVGroup.h"
  #include "HDFFile.h"

  enum mopch_open_code {MOPCH_OPEN_READ, MOPCH_OPEN_WRITE};

  class mopch_file : public hdf_file {
    private :
      static int const OPEN_ERROR;
      static int const CLOSE_WARNING;

    protected :
      hdf_vgroup tablegroup;
      hdf_vgroup sciencegroup;
      hdf_vgroup engineeringgroup;

      bool Close ();
      bool Open  (enum mopch_open_code);

    public :
      mopch_file (PGSt_PC_Logical);
      mopch_file ();
      virtual ~mopch_file () = 0;

      int32 GetEngineeringID () const {return engineeringgroup.GetID ();}
      int32 GetScienceID     () const {return sciencegroup.GetID ();}
      int32 GetTableID       () const {return tablegroup.GetID ();}
  };

#endif
