 /********** MOPCHFile.C ***********************************************************************************************\

 $Header$

 REVISION HISTORY
   12/98  Charles Cavanaugh

 $Log$

\**********************************************************************************************************************/

#include "MOPCHFile.h"
#include "HdfEosDef.h"
#include "DiagnosticReporter.h"

extern diagnostic_reporter diagnosticreporter;

int const mopch_file::OPEN_ERROR    = 900;
int const mopch_file::CLOSE_WARNING = 801;

mopch_file :: mopch_file ()
            : hdf_file ()
            , tablegroup ()
            , sciencegroup ()
            , engineeringgroup ()
{
  ;
}


mopch_file :: mopch_file (PGSt_PC_Logical filelogical)
            : hdf_file (filelogical)
            , tablegroup ()
            , sciencegroup ()
            , engineeringgroup ()
{
  ;
}


mopch_file :: ~mopch_file ()
{
  ;
}


bool mopch_file :: Close ()
{
  bool isclosed = false;

  if (IsOpen ())
    if (tablegroup.Close ())
      if (sciencegroup.Close ())
        if (engineeringgroup.Close ())
          if (hdf_file::Close ())
            isclosed = true;

  return isclosed;
}


bool mopch_file :: Open (enum mopch_open_code opencode)
{
  bool isopen = false;

  if (Initialize ())
    if (hdf_file::Open ((opencode == MOPCH_OPEN_READ ? DFACC_READ : DFACC_CREATE)))
      isopen = true;

  return isopen;
}
