/********** MOP01MetadataGroups.C *************************************************************************************\

 $Header$

 REVISION HISTORY
   06/99  Tom Lauren
   08/99  Charles Cavanaugh
   09/00  Charles Cavanaugh

 $Log$

\**********************************************************************************************************************/

#include "MOP01MetadataGroups.h"
#include "MOPIPFile.h"
#include "MOPIRCollection.h"
#include "MOPCHReadFile.h"
#include "ScienceCollection.h"
#include "EngineeringCollection.h"
#include "TableCollection.h"

mop01_metadata_groups :: mop01_metadata_groups ()
{
  ;
}


mop01_metadata_groups :: ~mop01_metadata_groups ()
{
  ;
}


bool mop01_metadata_groups :: Set (PGSt_PC_Logical hdffilelogical, mopitt_time const& starttime, 
                                   mopitt_time const& stoptime, int radmissing, int radoutofbounds,
                                   int radinterpolated, mopitt_time const& prehot1cal, mopitt_time const& prehot2cal,
                                   mopitt_time const& prehot3cal, mopitt_time const& prehot4cal, 
                                   mopitt_time const& posthot1cal, mopitt_time const& posthot2cal,
                                   mopitt_time const& posthot3cal, mopitt_time const& posthot4cal, 
                                   char const* eventdesc, PGSt_MET_handle handle)
{
  bool isset = false;

  if (inputgranule.Set (handle, 66, MOPIP_FILE_LOGICAL, MOPIR_FILE_0_LOGICAL, MOPIR_FILE_1_LOGICAL,
                        MOPIR_FILE_2_LOGICAL, MOPIR_FILE_3_LOGICAL, MOPCH_CURRENT_GRANULE_FILELOGICAL,
                        SCIENCE_COLLECTION_01_LOGICAL, SCIENCE_COLLECTION_02_LOGICAL, SCIENCE_COLLECTION_03_LOGICAL,
                        SCIENCE_COLLECTION_04_LOGICAL, SCIENCE_COLLECTION_05_LOGICAL, SCIENCE_COLLECTION_06_LOGICAL, 
                        SCIENCE_COLLECTION_07_LOGICAL, SCIENCE_COLLECTION_08_LOGICAL, SCIENCE_COLLECTION_09_LOGICAL,
                        SCIENCE_COLLECTION_10_LOGICAL, SCIENCE_COLLECTION_11_LOGICAL, SCIENCE_COLLECTION_12_LOGICAL,
                        ENGINEERING_COLLECTION_01_LOGICAL, ENGINEERING_COLLECTION_02_LOGICAL, 
                        ENGINEERING_COLLECTION_03_LOGICAL, ENGINEERING_COLLECTION_04_LOGICAL, 
                        ENGINEERING_COLLECTION_05_LOGICAL, ENGINEERING_COLLECTION_06_LOGICAL, 
                        ENGINEERING_COLLECTION_07_LOGICAL, ENGINEERING_COLLECTION_08_LOGICAL, 
                        ENGINEERING_COLLECTION_09_LOGICAL, ENGINEERING_COLLECTION_10_LOGICAL, 
                        ENGINEERING_COLLECTION_11_LOGICAL, ENGINEERING_COLLECTION_12_LOGICAL,
                        TABLE_COLLECTION_01_LOGICAL, TABLE_COLLECTION_02_LOGICAL, TABLE_COLLECTION_03_LOGICAL,
                        TABLE_COLLECTION_04_LOGICAL, TABLE_COLLECTION_05_LOGICAL, TABLE_COLLECTION_06_LOGICAL, 
                        TABLE_COLLECTION_07_LOGICAL, TABLE_COLLECTION_08_LOGICAL, TABLE_COLLECTION_09_LOGICAL,
                        TABLE_COLLECTION_10_LOGICAL, TABLE_COLLECTION_11_LOGICAL, TABLE_COLLECTION_12_LOGICAL,
                        MOPCH_PRE_GRANULE_TRAIN_1_COLD_FILELOGICAL,  MOPCH_PRE_GRANULE_TRAIN_2_COLD_FILELOGICAL,
                        MOPCH_PRE_GRANULE_TRAIN_3_COLD_FILELOGICAL,  MOPCH_PRE_GRANULE_TRAIN_4_COLD_FILELOGICAL,
                        MOPCH_PRE_GRANULE_TRAIN_1_WARM_FILELOGICAL,  MOPCH_PRE_GRANULE_TRAIN_2_WARM_FILELOGICAL,
                        MOPCH_PRE_GRANULE_TRAIN_3_WARM_FILELOGICAL,  MOPCH_PRE_GRANULE_TRAIN_4_WARM_FILELOGICAL,
                        MOPCH_PRE_GRANULE_TRAIN_1_HOT_FILELOGICAL,   MOPCH_PRE_GRANULE_TRAIN_2_HOT_FILELOGICAL,
                        MOPCH_PRE_GRANULE_TRAIN_3_HOT_FILELOGICAL,   MOPCH_PRE_GRANULE_TRAIN_4_HOT_FILELOGICAL,
                        MOPCH_POST_GRANULE_TRAIN_1_COLD_FILELOGICAL, MOPCH_POST_GRANULE_TRAIN_2_COLD_FILELOGICAL,
                        MOPCH_POST_GRANULE_TRAIN_3_COLD_FILELOGICAL, MOPCH_POST_GRANULE_TRAIN_4_COLD_FILELOGICAL,
                        MOPCH_POST_GRANULE_TRAIN_1_WARM_FILELOGICAL, MOPCH_POST_GRANULE_TRAIN_2_WARM_FILELOGICAL,
                        MOPCH_POST_GRANULE_TRAIN_3_WARM_FILELOGICAL, MOPCH_POST_GRANULE_TRAIN_4_WARM_FILELOGICAL,
                        MOPCH_POST_GRANULE_TRAIN_1_HOT_FILELOGICAL,  MOPCH_POST_GRANULE_TRAIN_2_HOT_FILELOGICAL,
                        MOPCH_POST_GRANULE_TRAIN_3_HOT_FILELOGICAL,  MOPCH_POST_GRANULE_TRAIN_4_HOT_FILELOGICAL))
    if (radiances.Set (handle, "Radiance", 1, radmissing, radoutofbounds, radinterpolated))
      if (boundingrectangle.Set (handle))
        if (ecsdatagranule.Set (handle, hdffilelogical))
          if (pgeversionclass.Set (handle, hdffilelogical))
            if (rangedatetime.Set (handle, starttime, stoptime))
              if (orbitspatialdomain.Set (handle, starttime, stoptime))
                if (mop01psas.Set (handle, prehot1cal, prehot2cal, prehot3cal, prehot4cal, posthot1cal, posthot2cal, 
                                   posthot3cal, posthot4cal, eventdesc))
                  isset = true;

  return isset;
}
