/********** MOP01Metadata.C *******************************************************************************************\

 $Header$

 REVISION HISTORY
   06/99  Tom Lauren
   08/99  Charles Cavanaugh

 $Log$

\**********************************************************************************************************************/

#include "MOP01Metadata.h"
#include "MOP01GlobalMetadata.h"
#include "GlobalMetadata.h"
#include "DiagnosticReporter.h"

extern diagnostic_reporter diagnosticreporter;

PGSt_PC_Logical const mop01_metadata::MOP01_MCF_FILELOGICAL    = 41601;
int const             mop01_metadata::TYPICAL_NUMBER_OF_TRACKS = 6421;

mop01_metadata :: mop01_metadata ()
                : hdf_metadata ()
{
  ;
}


mop01_metadata :: mop01_metadata (PGSt_PC_Logical hdffilelogical)
                : hdf_metadata (MOP01_MCF_FILELOGICAL)
{
  Set (hdffilelogical);
}


mop01_metadata :: ~mop01_metadata ()
{
  ;
}


bool mop01_metadata :: Set (PGSt_PC_Logical hdffilelogical)
{
  bool isset = false;

  // Initialize the metadata mechanism
  if (Initialize ()) {
  
    // store the metadata (extracting necessary stuff from global metadata)
    extern global_metadata globalmetadata;
    extern mop01_global_metadata mop01globalmetadata;
    char eventdesc [500];
    mop01globalmetadata.GetEventDesc (eventdesc);
    int radcount = (int) globalmetadata.GetTrackCount ();
    int radmissing = (int) (100.5 - (100.0 * ((float) radcount / TYPICAL_NUMBER_OF_TRACKS)));
    if (radmissing < 0) 
      radmissing = 0;
    int radoutofbounds = (int) (100.5 - ((radcount - globalmetadata.GetTracksOutofBounds ()) / (0.01 * radcount)));
    int radinterpolated = 0;
    if (mop01metadatagroups.Set (hdffilelogical, globalmetadata.GetStartTime (), globalmetadata.GetStopTime (),
                                 radmissing, radoutofbounds, radinterpolated, mop01globalmetadata.GetPreHot1Cal (), 
                                 mop01globalmetadata.GetPreHot2Cal (), mop01globalmetadata.GetPreHot3Cal (), 
                                 mop01globalmetadata.GetPreHot4Cal (), mop01globalmetadata.GetPostHot1Cal (), 
                                 mop01globalmetadata.GetPostHot2Cal (), mop01globalmetadata.GetPostHot3Cal (), 
                                 mop01globalmetadata.GetPostHot4Cal (), eventdesc, GetHandle ()))
      isset = true;
    }
  return isset;
}


bool mop01_metadata :: Write (PGSt_PC_Logical hdffilelogical)
{
  bool iswrite = false;

  PGSt_integer mid;
  PGSt_SMF_status status;
  char msg[PGS_SMF_MAX_MSG_SIZE];
  char err[PGS_SMF_MAX_MNEMONIC_SIZE];
  PGSt_integer version = 1;
  char filename [PGSd_PC_FILE_PATH_MAX]="";

  if (PGS_PC_GetReference (hdffilelogical, &version, filename) != PGS_S_SUCCESS)
    diagnosticreporter.AddEntry (DIAGNOSTICS_ERROR, DIAGNOSTICS_METADATA_MODULE, 998, hdffilelogical, 0, 0, 0, 
				 0, 0, 0, 0, "Could not get MOP01 filename");
  else {
    status=PGS_MET_SDstart (filename, HE5F_ACC_RDWR, &mid);
    if (status != PGS_S_SUCCESS) {
      PGS_SMF_GetMsg(&status, err, msg);
      diagnosticreporter.AddEntry (DIAGNOSTICS_ERROR, DIAGNOSTICS_METADATA_MODULE, 999, 0, 0, 0, 0, 0, 0, 0, 0, msg);
    } 
    
    if (hdf_metadata::Write (mid))
      iswrite = true;

    (void) PGS_MET_SDend (mid);
  }

  return iswrite;
}
