/********** MOP01GlobalMetadata.h *************************************************************************************\

 $Header$

 REVISION HISTORY
   08/99  Charles Cavanaugh

 $Log$

\**********************************************************************************************************************/

#if !defined _MOPITT_L1_MOP01_GLOBAL_METADATA_

  #define _MOPITT_L1_MOP01_GLOBAL_METADATA_

  #include "MOPITTTime.h"

  class mop01_global_metadata {
    private:
      static int const EVENT_DESCRIPTION_SIZE = 255;

      mopitt_time prehot1cal;
      mopitt_time prehot2cal;
      mopitt_time prehot3cal;
      mopitt_time prehot4cal;
      mopitt_time posthot1cal;
      mopitt_time posthot2cal;
      mopitt_time posthot3cal;
      mopitt_time posthot4cal;
      char        eventdescription [EVENT_DESCRIPTION_SIZE];

    protected:

    public:
      mop01_global_metadata ();
      ~mop01_global_metadata ();

      mopitt_time const& GetPreHot1Cal      () const {return prehot1cal;}
      mopitt_time const& GetPreHot2Cal      () const {return prehot2cal;}
      mopitt_time const& GetPreHot3Cal      () const {return prehot3cal;}
      mopitt_time const& GetPreHot4Cal      () const {return prehot4cal;}
      mopitt_time const& GetPostHot1Cal     () const {return posthot1cal;}
      mopitt_time const& GetPostHot2Cal     () const {return posthot2cal;}
      mopitt_time const& GetPostHot3Cal     () const {return posthot3cal;}
      mopitt_time const& GetPostHot4Cal     () const {return posthot4cal;}
      void               GetEventDesc       (char []);
      void               SetPreHot1Cal      (mopitt_time const&);
      void               SetPreHot2Cal      (mopitt_time const&);
      void               SetPreHot3Cal      (mopitt_time const&);
      void               SetPreHot4Cal      (mopitt_time const&);
      void               SetPostHot1Cal     (mopitt_time const&);
      void               SetPostHot2Cal     (mopitt_time const&);
      void               SetPostHot3Cal     (mopitt_time const&);
      void               SetPostHot4Cal     (mopitt_time const&);
      void               SetEventDesc       (char const*);
      void               SetTimes           (mopitt_time const&, mopitt_time const&, mopitt_time const&, 
                                             mopitt_time const&, mopitt_time const&, mopitt_time const&, 
                                             mopitt_time const&, mopitt_time const&);
  };
 
#endif
