/********** MOP01File.C ***********************************************************************************************\

 $Header$

 REVISION HISTORY
   12/98   Charles Cavanaugh
   06/99   Tom Lauren
   09/99   Charles Cavanaugh

 $Log$

\**********************************************************************************************************************/

#include "MOP01File.h"
#include "MOP01Metadata.h"
#include <PGS_SMF.h>
#include <PGS_MET.h>

PGSt_PC_Logical const mop01_file::MOP01_FILE_LOGICAL = 41600;

mop01_file :: mop01_file ()
            : hdfeos_file (MOP01_FILE_LOGICAL)
{
  Open ();
}


mop01_file :: ~mop01_file ()
{
  Close ();
}


bool mop01_file :: Close ()
{
  bool isclosed = false;

  if (IsOpen ())
    if (tracksgroup.Close ()) {
      mop01_metadata mop01metadata (MOP01_FILE_LOGICAL);
      if (hdfeos_file::Close ())
	if (mop01metadata.Write (MOP01_FILE_LOGICAL))
	  isclosed = true;
    }

  return isclosed;
}


bool mop01_file :: Open ()
{
  bool isopen = false;

  if (Initialize ())
    if (hdfeos_file::Open (H5F_ACC_TRUNC))
      if (tracksgroup.Create ("MOP01", fileid))
	isopen = true;

  return isopen;
}
